<?php $__env->startSection('title', 'Crear Organismo'); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/organismos.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <h2 class="text-gray font-weight-bold mb-4" >Nuevo Organismo</h2>
    <?php if (isset($component)) { $__componentOriginalb24df6adf99a77ed35057e476f61e153 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb24df6adf99a77ed35057e476f61e153 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.validation-errors','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('validation-errors'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb24df6adf99a77ed35057e476f61e153)): ?>
<?php $attributes = $__attributesOriginalb24df6adf99a77ed35057e476f61e153; ?>
<?php unset($__attributesOriginalb24df6adf99a77ed35057e476f61e153); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb24df6adf99a77ed35057e476f61e153)): ?>
<?php $component = $__componentOriginalb24df6adf99a77ed35057e476f61e153; ?>
<?php unset($__componentOriginalb24df6adf99a77ed35057e476f61e153); ?>
<?php endif; ?>
    
    <div class="hierarchy-selector">
        <h5 class="text-muted mb-3"><i class="fas fa-sitemap"></i> Ubicación en el Organigrama</h5>

        <div class="row">
            <div class="col-md-3">
                <div class="level-selector">
                    <div class="level-indicator">Nivel 1 (Raíz)</div>
                    <select id="level1" class="form-control" onchange="updateHierarchy(1)">
                        <option value="">Crear en nivel raíz</option>
                        <?php $__currentLoopData = $organismos->whereNull('parent_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $org): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($org->id); ?>" data-name="<?php echo e($org->nombre); ?>"><?php echo e($org->nombre); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            
            <div class="col-md-3">
                <div class="level-selector">
                    <div class="level-indicator">Nivel 2</div>
                    <select id="level2" class="form-control disabled-select" disabled onchange="updateHierarchy(2)">
                        <option value="">Seleccionar...</option>
                    </select>
                </div>
            </div>
            
            <div class="col-md-3">
                <div class="level-selector">
                    <div class="level-indicator">Nivel 3</div>
                    <select id="level3" class="form-control disabled-select" disabled onchange="updateHierarchy(3)">
                        <option value="">Seleccionar...</option>
                    </select>
                </div>
            </div>
            
            <div class="col-md-3">
                <div class="level-selector">
                    <div class="level-indicator">Nivel 4</div>
                    <select id="level4" class="form-control disabled-select" disabled onchange="updateHierarchy(4)">
                        <option value="">Seleccionar...</option>
                    </select>
                </div>
            </div>
        </div>
        
        <div class="hierarchy-path" id="hierarchyPath">
            <strong>Ubicación:</strong> <span id="pathText">Nivel raíz (sin organismo padre)</span>
        </div>
    </div>

    <form action="<?php echo e(route('admin.organismos.store')); ?>" method="POST" id="organismoForm">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="parent_id" id="selectedParentId" value="">
        
        <div class="mb-3">
            <label for="nombre" class="form-label">Nombre *</label>
            <input type="text" name="nombre" id="nombre" class="form-control" value="<?php echo e(old('nombre')); ?>" required>
        </div>
        
        <div class="mb-3">
            <label for="descripcion" class="form-label">Descripción</label>
            <textarea name="descripcion" id="descripcion" class="form-control" rows="3"><?php echo e(old('descripcion')); ?></textarea>
        </div>
        
        <div class="mb-3">
            <label for="direccion" class="form-label">Dirección</label>
            <input type="text" name="direccion" id="direccion" class="form-control" value="<?php echo e(old('direccion')); ?>">
        </div>
        
        <div class="mb-3">
            <label for="telefono" class="form-label">Teléfono</label>
            <input type="text" name="telefono" id="telefono" class="form-control" value="<?php echo e(old('telefono')); ?>">
        </div>
        
        <div class="mb-3">
            <label for="email" class="form-label">Email</label>
            <input type="email" name="email" id="email" class="form-control" value="<?php echo e(old('email')); ?>">
        </div>
        
        <button type="submit" class="btn btn-primary">Guardar</button>
        <a href="<?php echo e(route('admin.organismos.index')); ?>" class="btn btn-secondary">Volver</a>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="<?php echo e(asset('js/toast-handler.js')); ?>"></script>
    <script>
        window.successMessage = <?php echo json_encode(session('success'), 15, 512) ?>;
        window.errorMessage = <?php echo json_encode(session('error'), 15, 512) ?>;
        window.errorMessages = <?php echo json_encode($errors->any() ? implode('<br>', $errors->all()) : null, 512) ?>;
    </script>
    <script src="<?php echo e(asset('js/organismos-create.js')); ?>"></script>
    <script>
        // Función para actualizar la jerarquía cuando se selecciona un nivel
        function updateHierarchy(level) {
            const currentSelect = document.getElementById(`level${level}`);
            const selectedValue = currentSelect.value;
            const selectedName = currentSelect.options[currentSelect.selectedIndex]?.getAttribute('data-name') || '';
            
            // Limpiar niveles siguientes
            for (let i = level + 1; i <= 4; i++) {
                const nextSelect = document.getElementById(`level${i}`);
                nextSelect.innerHTML = '<option value="">Seleccionar...</option>';
                nextSelect.disabled = true;
                nextSelect.classList.add('disabled-select');
            }
            
            if (selectedValue && level < 4) {
                const nextLevel = level + 1;
                const nextSelect = document.getElementById(`level${nextLevel}`);
                
                loadChildren(selectedValue, nextSelect);
                
                nextSelect.disabled = false;
                nextSelect.classList.remove('disabled-select');
            }
            
            // Actualizar el path y el parent_id
            updatePath();
            updateParentId();
        }

        function loadChildren(parentId, selectElement) {
            fetch(`/admin/organismos/${parentId}/children-ajax`)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        selectElement.innerHTML = '<option value="">Crear organismo en este nivel</option>';
                        data.children.forEach(child => {
                            const option = document.createElement('option');
                            option.value = child.id;
                            option.setAttribute('data-name', child.nombre);
                            option.textContent = child.nombre;
                            selectElement.appendChild(option);
                        });
                    }
                })
                .catch(error => console.error('Error cargando organismos dependientes:', error));
        }

        function updatePath() {
            let path = [];
            let currentLevel = 1;
            
            while (currentLevel <= 4) {
                const select = document.getElementById(`level${currentLevel}`);
                const selectedOption = select.options[select.selectedIndex];
                
                if (select.value) {
                    const name = selectedOption.getAttribute('data-name') || selectedOption.textContent;
                    path.push(`Nivel ${currentLevel}: ${name}`);
                    currentLevel++;
                } else {
                    break;
                }
            }
            
            const pathText = document.getElementById('pathText');
            if (path.length === 0) {
                pathText.textContent = 'Nivel raíz (sin organismo padre)';
            } else {
                const nextLevel = path.length + 1;
                pathText.innerHTML = path.join(' → ') + ` → <strong>Nuevo organismo (Nivel ${nextLevel})</strong>`;
            }
        }

        // Función para actualizar el parent_id del formulario
        function updateParentId() {
            let parentId = '';
            
            // Buscar el último nivel seleccionado
            for (let i = 4; i >= 1; i--) {
                const select = document.getElementById(`level${i}`);
                if (select.value) {
                    parentId = select.value;
                    break;
                }
            }
            
            document.getElementById('selectedParentId').value = parentId;
        }

        // Inicializar al cargar la página
        document.addEventListener('DOMContentLoaded', function() {
            updatePath(); // Mostrar path inicial
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/siac/resources/views/admin/organismos/create.blade.php ENDPATH**/ ?>