<?php $__env->startSection('title', 'Usuarios'); ?>

<?php $__env->startPush('styles'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/admin-users.css']); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="users-header">
    <h2 class="text-gray font-weight-bold">Usuarios</h2>
    
    <div class="d-flex justify-content-end">
        <a href="<?php echo e(route('admin.users.create')); ?>" class="btn btn-primary">
            Nuevo <i class="fas fa-plus"></i>
        </a>
    </div>
    
    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    
    <div class="admin-responsive-table table-scroll-indicator">
        <table class="table table-bordered table-striped users-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nombres</th>
                    <th>Apellidos</th>
                    <th>Email</th>
                    <th>Teléfono</th>
                    <th>Rol</th>
                    <th class="expandable-cell">Organismo</th>
                    <th class="actions-cell">Acciones</th>
                </tr>
            </thead>
        <tbody>
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($user->id); ?></td>
                    <td><?php echo e($user->first_name); ?></td>
                    <td><?php echo e($user->last_name); ?></td>
                    <td><?php echo e($user->email); ?></td>
                    <td><?php echo e($user->telefono ?: '-'); ?></td>
                    <td><?php echo e(ucfirst($user->role)); ?></td>
                    <td><?php echo e($user->organismo?->nombre ?? '-'); ?></td>
                    <td class="actions-cell">
                        <a href="<?php echo e(route('admin.users.edit', $user->id)); ?>" 
                           class="btn btn-sm btn-action btn-edit"
                           title="Editar usuario">
                            <i class="fas fa-edit"></i>
                        </a>
                        <form action="<?php echo e(route('admin.users.destroy', $user->id)); ?>" 
                              method="POST" 
                              style="display:inline-block;"
                              class="delete-user-form">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" 
                                    class="btn btn-sm btn-action btn-delete"
                                    title="Eliminar usuario">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    </div>
    
    <?php if($users->hasPages()): ?>
        <div class="pagination-wrapper">
            <?php echo e($users->links()); ?>

        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin-users.js']); ?>
    <script>
        // Variables globales para el contexto
        window.successMessage = <?php echo json_encode(session('success'), 15, 512) ?>;
        window.errorMessage = <?php echo json_encode(session('error'), 15, 512) ?>;
        window.errorMessages = <?php echo json_encode($errors->any() ? implode('<br>', $errors->all()) : null, 512) ?>;
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/siac/resources/views/admin/users/index.blade.php ENDPATH**/ ?>