<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Solicitud Cerrada - SIAC</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
        }

        .header {
            background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }

        .header h1 {
            font-size: 24px;
            margin-bottom: 10px;
        }

        .header .subtitle {
            font-size: 16px;
            opacity: 0.9;
        }

        .content {
            padding: 40px 30px;
        }

        .greeting {
            font-size: 18px;
            margin-bottom: 20px;
            color: #2c3e50;
        }

        .message {
            background-color: #e8f5e8;
            border-left: 4px solid #28a745;
            padding: 20px;
            margin: 25px 0;
            border-radius: 4px;
        }

        .message .icon {
            font-size: 24px;
            margin-bottom: 10px;
            color: #28a745;
        }

        .details {
            background-color: #f8f9fa;
            border-radius: 8px;
            padding: 25px;
            margin: 25px 0;
        }

        .details h3 {
            color: #495057;
            margin-bottom: 15px;
            border-bottom: 2px solid #dee2e6;
            padding-bottom: 10px;
        }

        .detail-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 0;
            border-bottom: 1px solid #e9ecef;
        }

        .detail-row:last-child {
            border-bottom: none;
        }

        .detail-label {
            font-weight: 600;
            color: #6c757d;
            flex: 1;
        }

        .detail-value {
            flex: 2;
            text-align: right;
            color: #495057;
        }

        .status-badge {
            background-color: #28a745;
            color: white;
            padding: 5px 12px;
            border-radius: 15px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
        }

        .footer {
            background-color: #2c3e50;
            color: #ecf0f1;
            padding: 30px;
            text-align: center;
        }

        .footer p {
            margin-bottom: 10px;
        }

        .footer .contact {
            font-size: 14px;
            opacity: 0.8;
        }

        .btn {
            display: inline-block;
            padding: 12px 25px;
            background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: 600;
            margin: 20px 0;
            transition: all 0.3s ease;
        }

        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 123, 255, 0.3);
        }

        @media (max-width: 600px) {
            .container {
                margin: 0;
                border-radius: 0;
            }

            .content,
            .header,
            .footer {
                padding: 20px;
            }

            .detail-row {
                flex-direction: column;
                align-items: flex-start;
            }

            .detail-value {
                text-align: left;
                margin-top: 5px;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1>✅ Solicitud Completada</h1>
            <p class="subtitle">Sistema Integrado de Atención Ciudadana</p>
        </div>

        <!-- Content -->
        <div class="content">
            <div class="greeting">
                Estimado/a <?php echo e($solicitante_nombre); ?>,
            </div>

            <div class="message">
                <div class="icon">🎉</div>
                <p><strong>¡Excelentes noticias!</strong> Su solicitud ha sido procesada y cerrada exitosamente por
                    nuestro equipo.</p>
            </div>

            <p>Le informamos que su solicitud registrada en nuestro sistema ha sido completada satisfactoriamente. A
                continuación, encontrará los detalles de su solicitud:</p>

            <!-- Detalles de la solicitud -->
            <div class="details">
                <h3>📋 Detalles de la Solicitud</h3>

                <div class="detail-row">
                    <span class="detail-label">Número de Solicitud:</span>
                    <span class="detail-value"><strong>#<?php echo e($solicitud->id); ?></strong></span>
                </div>

                <div class="detail-row">
                    <span class="detail-label">Tipo de Solicitud:</span>
                    <span class="detail-value"><?php echo e($tipo_solicitud); ?></span>
                </div>

                <div class="detail-row">
                    <span class="detail-label">Organismo:</span>
                    <span class="detail-value"><?php echo e($organismo); ?></span>
                </div>

                <div class="detail-row">
                    <span class="detail-label">Estado:</span>
                    <span class="detail-value">
                        <span class="status-badge">Cerrada</span>
                    </span>
                </div>

                <div class="detail-row">
                    <span class="detail-label">Fecha de Creación:</span>
                    <span class="detail-value"><?php echo e($solicitud->created_at->format('d/m/Y H:i')); ?></span>
                </div>

                <div class="detail-row">
                    <span class="detail-label">Fecha de Cierre:</span>
                    <span class="detail-value"><?php echo e(\Carbon\Carbon::parse($fecha_cierre)->format('d/m/Y H:i')); ?></span>
                </div>

                <div class="detail-row">
                    <span class="detail-label">Tiempo de Resolución:</span>
                    <span class="detail-value"><strong><?php echo e($tiempo_resolucion); ?></strong></span>
                </div>

                <?php if($gestor): ?>
                    <div class="detail-row">
                        <span class="detail-label">Gestor Asignado:</span>
                        <span class="detail-value"><?php echo e($gestor->name); ?></span>
                    </div>
                <?php endif; ?>
            </div>

            <?php if($solicitud->observaciones_cierre): ?>
                <div class="details">
                    <h3>📝 Observaciones del Cierre</h3>
                    <p style="margin-top: 15px; line-height: 1.6;"><?php echo e($solicitud->observaciones_cierre); ?></p>
                </div>
            <?php endif; ?>

            <p>Si tiene alguna consulta adicional o necesita más información sobre esta solicitud, no dude en
                contactarnos.</p>

            <div style="text-align: center; margin: 30px 0;">
                <a href="#" class="btn">Ver Detalles en el Sistema</a>
            </div>

            <div
                style="background-color: #fff3cd; border: 1px solid #ffeaa7; border-radius: 8px; padding: 20px; margin: 25px 0;">
                <p style="margin: 0; color: #856404;"><strong>💡 Importante:</strong> Este correo es generado
                    automáticamente. Si necesita realizar una nueva solicitud, puede acceder a nuestro sistema o
                    contactar directamente con el organismo correspondiente.</p>
            </div>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p><strong>Sistema Integrado de Atención Ciudadana (SIAC)</strong></p>
            <p><strong>Municipalidad de Loncoche</strong></p>
            <p class="contact">
                📧 siac@muniloncochedigital.cl | 📞 +56452406565<br>
                🌐 https://municipalidaddeloncoche.cl/
            </p>
            <p style="font-size: 12px; opacity: 0.7; margin-top: 20px;">
                © <?php echo e(date('Y')); ?> SIAC. Todos los derechos reservados.<br>
                Este mensaje fue enviado a <?php echo e($solicitud->email); ?>

            </p>
        </div>
    </div>
</body>

</html><?php /**PATH /var/www/html/siac/resources/views/emails/solicitud-cerrada.blade.php ENDPATH**/ ?>