<?php $__env->startSection('title', 'Organismos'); ?>

<?php $__env->startPush('styles'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/admin.css']); ?>
    <style>
        .parent-row {
            font-weight: 500;
        }
        .child-row {
            font-size: 0.95em;
        }
        .level-1 { padding-left: 15px !important; }
        .level-2 { padding-left: 30px !important; }
        .level-3 { padding-left: 45px !important; }
        .level-4 { padding-left: 60px !important; }
        
        .toggle-children {
            border: none !important;
            background: transparent !important;
            padding: 2px 6px !important;
            transition: all 0.3s ease;
            font-size: 0.8em;
        }
        .toggle-children:hover {
            background-color: rgba(0,0,0,0.15) !important;
            border-radius: 3px;
        }
        .badge-secondary {
            font-size: 0.65em;
            padding: 2px 5px;
            background-color: #6c757d;
            color: white;
            border-radius: 0.25rem;
        }
        
        /* Dos colores sobrios intercalados */
        .color-even {
            background-color: #f8f9fa !important;
        }
        .color-odd {
            background-color: #ffffff !important;
        }
        
        .child-row {
            opacity: 0.9;
        }
        
        .hierarchy-icon {
            color: #6c757d;
            font-size: 0.8em;
            margin-right: 5px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="admin-header">
        <h2 class="page-title">Listado de Organismos</h2>
        <div class="d-flex justify-content-end">
            <a href="<?php echo e(route('admin.organismos.create')); ?>" class="btn btn-primary">
                Nuevo
                <i class="fas fa-plus ms-1"></i>
            </a>
        </div>
    </div>

    <div class="admin-responsive-table table-scroll-indicator">
        <table class="table table-hover mb-0" id="organismosTable">
            <thead>
                <tr>
                    <th style="width: 40px;"></th>
                    <th>ID</th>
                    <th class="expandable-cell">Nombre</th>
                    <th class="expandable-cell">Descripción</th>
                    <th class="expandable-cell">Dirección</th>
                    <th>Teléfono</th>
                    <th>Email</th>
                    <th class="text-center actions-cell" style="width: 150px;">Acciones</th>
                </tr>
            </thead>
            <tbody>
            <?php
                // Función recursiva para renderizar organismos y sus hijos
                function renderOrganismo($organismo, $allOrganismos, $level = 0, $colorIndex = 0, $parentIds = []) {
                    $children = $allOrganismos->where('parent_id', $organismo->id);
                    $hasChildren = $children->count() > 0;
                    $colorClass = ($colorIndex % 2 == 0) ? 'color-even' : 'color-odd';
                    $isVisible = $level == 0 ? '' : 'style="display: none;"';
                    $levelClass = $level > 0 ? "level-{$level}" : '';
                    $parentIdsStr = implode(',', $parentIds);
                    
                    // Iconos según nivel
                    $icons = [
                        0 => '', 
                        1 => '<i class="fas fa-arrow-right hierarchy-icon"></i>',
                        2 => '<i class="fas fa-arrow-right hierarchy-icon"></i><i class="fas fa-arrow-right hierarchy-icon"></i>',
                        3 => '<i class="fas fa-arrow-right hierarchy-icon"></i><i class="fas fa-arrow-right hierarchy-icon"></i><i class="fas fa-arrow-right hierarchy-icon"></i>'
                    ];
                    
                    echo '<tr class="' . ($level == 0 ? 'parent-row' : 'child-row') . ' ' . $colorClass . '" 
                            data-level="' . $level . '" 
                            data-parent-ids="' . $parentIdsStr . '"
                            data-organismo-id="' . $organismo->id . '"
                            ' . $isVisible . '>';
                    
                    echo '<td class="text-center">';
                    if ($hasChildren && $level < 3) {  // Máximo 4 niveles (0,1,2,3)
                        echo '<button type="button" class="btn btn-sm btn-outline-secondary toggle-children" 
                                data-organismo-id="' . $organismo->id . '" 
                                data-level="' . $level . '" 
                                title="Expandir/Contraer">
                                <i class="fas fa-chevron-right"></i>
                              </button>';
                    } else {
                        echo '<span style="display: inline-block; width: 32px;"></span>';
                    }
                    echo '</td>';
                    
                    echo '<td>' . ($level == 0 ? '<strong>' . $organismo->id . '</strong>' : $organismo->id) . '</td>';
                    
                    echo '<td class="' . $levelClass . '">';
                    echo ($level > 0 ? $icons[$level] : '');
                    echo ($level == 0 ? '<strong>' . $organismo->nombre . '</strong>' : $organismo->nombre);
                    if ($hasChildren) {
                        echo ' <span class="badge badge-secondary ml-2">' . $children->count() . '</span>';
                    }
                    echo '</td>';
                    
                    echo '<td>' . $organismo->descripcion . '</td>';
                    echo '<td>' . $organismo->direccion . '</td>';
                    echo '<td>' . $organismo->telefono . '</td>';
                    echo '<td>' . $organismo->email . '</td>';
                    
                    echo '<td class="text-center">
                            <div class="btn-actions">
                                <button type="button" class="btn btn-sm btn-outline-info" onclick="loadViewModal(' . $organismo->id . ')" title="Ver">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-warning" onclick="loadEditModal(' . $organismo->id . ')" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <form action="' . route('admin.organismos.destroy', $organismo->id) . '" method="POST" class="d-inline delete-organismo-form">
                                    ' . csrf_field() . '
                                    ' . method_field('DELETE') . '
                                    <button type="submit" class="btn btn-sm btn-outline-danger" title="Eliminar">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                          </td>';
                    
                    echo '</tr>';
                    
                    // Renderizar hijos recursivamente
                    if ($hasChildren && $level < 3) {
                        foreach ($children as $child) {
                            $newParentIds = array_merge($parentIds, [$organismo->id]);
                            renderOrganismo($child, $allOrganismos, $level + 1, $colorIndex, $newParentIds);
                        }
                    }
                }
                
                // Obtener organismos raíz (sin padre)
                $rootOrganismos = $organismos->whereNull('parent_id');
            ?>
            
            <?php if($rootOrganismos->count() > 0): ?>
                <?php
                    $colorIndex = 0;
                    foreach ($rootOrganismos as $organismo) {
                        renderOrganismo($organismo, $organismos, 0, $colorIndex);
                        $colorIndex++;
                    }
                ?>
            <?php else: ?>
                <tr>
                    <td colspan="8" class="empty-state">
                        <i class="fas fa-sitemap fa-2x mb-2 text-muted"></i>
                        <p class="mb-0">No hay organismos registrados.</p>
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
    </div>

    
    <?php echo $__env->make('components.dynamic-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="<?php echo e(asset('js/toast-handler.js')); ?>"></script>
    <script src="<?php echo e(asset('js/dynamic-modal.js')); ?>"></script>
    <script>
        // Variables globales para JS
        window.successMessage = <?php echo json_encode(session('success'), 15, 512) ?>;
        window.errorMessage = <?php echo json_encode(session('error'), 15, 512) ?>;
        window.errorMessages = <?php echo json_encode($errors->any() ? implode('<br>', $errors->all()) : null, 512) ?>;
        window.organismosIndexRoute = "<?php echo e(route('admin.organismos.index')); ?>";
    </script>
    <script src="<?php echo e(asset('js/organismos-index.js')); ?>"></script>
    <script>
        // Funcionalidad para expandir/contraer organismos hijos (4 niveles)
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.toggle-children').forEach(function(button) {
                button.addEventListener('click', function() {
                    const organismoId = this.getAttribute('data-organismo-id');
                    const level = parseInt(this.getAttribute('data-level'));
                    const icon = this.querySelector('i');
                    
                    // Encontrar todas las filas que son hijos directos e indirectos de este organismo
                    const allRows = document.querySelectorAll('tr[data-level]');
                    let childrenVisible = false;
                    
                    // Verificar si los hijos directos están visibles
                    const directChildren = document.querySelectorAll(`tr[data-level="${level + 1}"]`);
                    directChildren.forEach(function(row) {
                        const parentIds = row.getAttribute('data-parent-ids').split(',').filter(id => id !== '');
                        if (parentIds.length === level && (parentIds.length === 0 || parentIds[parentIds.length - 1] === organismoId || (level === 0 && parentIds.length === 0))) {
                            if (row.style.display !== 'none') {
                                childrenVisible = true;
                            }
                        }
                    });
                    
                    // Alternar visibilidad de todos los descendientes
                    allRows.forEach(function(row) {
                        const rowLevel = parseInt(row.getAttribute('data-level'));
                        if (rowLevel > level) {
                            const parentIds = row.getAttribute('data-parent-ids').split(',').filter(id => id !== '');
                            const rowOrganismoId = row.getAttribute('data-organismo-id');
                            
                            // Verificar si esta fila es descendiente del organismo clickeado
                            let isDescendant = false;
                            if (level === 0) {
                                // Para nivel 0, verificar si el organismoId está en la cadena de padres
                                isDescendant = parentIds.includes(organismoId);
                            } else {
                                // Para otros niveles, verificar la cadena completa
                                const buttonParentIds = button.closest('tr').getAttribute('data-parent-ids').split(',').filter(id => id !== '');
                                const buttonChain = [...buttonParentIds, organismoId];
                                
                                // Verificar si la cadena del botón está contenida en la cadena de la fila
                                isDescendant = buttonChain.every((id, index) => parentIds[index] === id);
                            }
                            
                            if (isDescendant) {
                                if (childrenVisible) {
                                    row.style.display = 'none';
                                    // También colapsar botones de niveles inferiores
                                    const nestedButton = row.querySelector('.toggle-children i');
                                    if (nestedButton) {
                                        nestedButton.classList.remove('fa-chevron-down');
                                        nestedButton.classList.add('fa-chevron-right');
                                    }
                                } else {
                                    if (rowLevel === level + 1) {
                                        row.style.display = 'table-row';
                                    }
                                }
                            }
                        }
                    });
                    
                    // Cambiar icono del botón clickeado
                    if (childrenVisible) {
                        icon.classList.remove('fa-chevron-down');
                        icon.classList.add('fa-chevron-right');
                    } else {
                        icon.classList.remove('fa-chevron-right');
                        icon.classList.add('fa-chevron-down');
                    }
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/siac/resources/views/admin/organismos/index.blade.php ENDPATH**/ ?>