<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Solicitud Recibida - SIAC</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
        }
        
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        
        .header {
            background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        
        .header h1 {
            font-size: 24px;
            margin-bottom: 10px;
        }
        
        .header .subtitle {
            font-size: 16px;
            opacity: 0.9;
        }
        
        .content {
            padding: 40px 30px;
        }
        
        .greeting {
            font-size: 18px;
            margin-bottom: 20px;
            color: #2c3e50;
        }
        
        .message {
            background-color: #e3f2fd;
            border-left: 4px solid #007bff;
            padding: 20px;
            margin: 25px 0;
            border-radius: 4px;
        }
        
        .message .icon {
            font-size: 24px;
            margin-bottom: 10px;
            color: #007bff;
        }
        
        .details {
            background-color: #f8f9fa;
            border-radius: 8px;
            padding: 25px;
            margin: 25px 0;
        }
        
        .details h3 {
            margin-bottom: 20px;
            color: #2c3e50;
            border-bottom: 2px solid #007bff;
            padding-bottom: 10px;
        }
        
        .detail-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
            padding: 10px 0;
            border-bottom: 1px solid #e9ecef;
        }
        
        .detail-row:last-child {
            border-bottom: none;
            margin-bottom: 0;
        }
        
        .detail-label {
            font-weight: 600;
            color: #495057;
            flex: 1;
        }
        
        .detail-value {
            text-align: right;
            color: #212529;
            flex: 1;
        }
        
        .status-badge {
            background-color: #ffc107;
            color: #212529;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
        }
        
        .footer {
            background-color: #2c3e50;
            color: #ecf0f1;
            padding: 30px;
            text-align: center;
        }
        
        .footer p {
            margin-bottom: 10px;
        }
        
        .footer .contact {
            font-size: 14px;
            opacity: 0.8;
        }
        
        .btn {
            display: inline-block;
            padding: 12px 25px;
            background: linear-gradient(135deg, #28a745 0%, #1e7e34 100%);
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: 600;
            margin: 20px 0;
            transition: all 0.3s ease;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(40,167,69,0.3);
        }
        
        .next-steps {
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
            border-radius: 8px;
            padding: 20px;
            margin: 25px 0;
        }
        
        .next-steps h4 {
            color: #155724;
            margin-bottom: 15px;
            font-size: 16px;
        }
        
        .next-steps ul {
            margin: 0;
            padding-left: 20px;
            color: #155724;
        }
        
        .next-steps li {
            margin-bottom: 8px;
            line-height: 1.5;
        }
        
        @media (max-width: 600px) {
            .container {
                margin: 0;
                border-radius: 0;
            }
            
            .content, .header, .footer {
                padding: 20px;
            }
            
            .detail-row {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .detail-value {
                text-align: left;
                margin-top: 5px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1>📨 Solicitud Recibida</h1>
            <p class="subtitle">Sistema Integrado de Atención Ciudadana</p>
        </div>

        <!-- Content -->
        <div class="content">
            <div class="greeting">
                Estimado/a <?php echo e($solicitante_nombre); ?>,
            </div>

            <div class="message">
                <div class="icon">✅</div>
                <p><strong>¡Su solicitud ha sido recibida exitosamente!</strong> Hemos registrado su requerimiento en nuestro sistema y será procesado a la brevedad.</p>
            </div>

            <p>Le confirmamos que hemos recibido su solicitud y que será atendida por el organismo correspondiente. A continuación, encontrará los detalles de su solicitud:</p>

            <!-- Detalles de la solicitud -->
            <div class="details">
                <h3>📋 Detalles de la Solicitud</h3>
                
                <div class="detail-row">
                    <span class="detail-label">Número de Solicitud:</span>
                    <span class="detail-value"><strong>#<?php echo e($solicitud->id); ?></strong></span>
                </div>
                
                <div class="detail-row">
                    <span class="detail-label">Tipo de Solicitud:</span>
                    <span class="detail-value"><?php echo e($tipo_solicitud); ?></span>
                </div>
                
                <div class="detail-row">
                    <span class="detail-label">Organismo:</span>
                    <span class="detail-value"><?php echo e($organismo); ?></span>
                </div>
                
                <div class="detail-row">
                    <span class="detail-label">Estado:</span>
                    <span class="detail-value">
                        <span class="status-badge">Pendiente</span>
                    </span>
                </div>
                
                <div class="detail-row">
                    <span class="detail-label">Fecha de Ingreso:</span>
                    <span class="detail-value"><?php echo e($solicitud->created_at->format('d/m/Y H:i')); ?></span>
                </div>
                
                <?php if($solicitud->detalle_solicitud): ?>
                <div class="detail-row">
                    <span class="detail-label">Detalle:</span>
                    <span class="detail-value"><?php echo e(\Str::limit($solicitud->detalle_solicitud, 100)); ?></span>
                </div>
                <?php endif; ?>
            </div>

            <!-- Próximos pasos -->
            <div class="next-steps">
                <h4>🔄 Próximos Pasos</h4>
                <ul>
                    <li><strong>Revisión inicial:</strong> Su solicitud será revisada y asignada a un gestor especializado</li>
                    <li><strong>Procesamiento:</strong> El organismo correspondiente analizará y procesará su requerimiento</li>
                    <li><strong>Notificaciones:</strong> Recibirá actualizaciones por correo electrónico sobre el progreso</li>
                    <li><strong>Resolución:</strong> Una vez completada, recibirá la respuesta final en este mismo correo</li>
                </ul>
            </div>

            <p><strong>Tiempo estimado de respuesta:</strong> 
                <?php if(isset($tiempo_limite_dias)): ?>
                    <?php echo e($tiempo_limite_dias); ?> días hábiles
                <?php else: ?>
                    Será informado una vez que se asigne un gestor
                <?php endif; ?>
            </p>

            <p>Si tiene alguna consulta sobre esta solicitud, puede contactarnos indicando el <strong>número de solicitud #<?php echo e($solicitud->id); ?></strong>.</p>

            <div style="background-color: #fff3cd; border: 1px solid #ffeaa7; border-radius: 8px; padding: 20px; margin: 25px 0;">
                <p style="margin: 0; color: #856404;"><strong>📧 Importante:</strong> Mantenga este correo como comprobante de su solicitud. Se le notificará automáticamente sobre cualquier actualización en el estado de su requerimiento.</p>
            </div>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p><strong>Sistema Integrado de Atención Ciudadana (SIAC)</strong></p>
            <p><strong>Municipalidad de Loncoche</strong></p>
            <p class="contact">
                📧 siac@muniloncochedigital.cl | 📞 +56 45 2411373<br>
                🌐 www.loncoche.cl
            </p>
            <p style="font-size: 12px; opacity: 0.7; margin-top: 20px;">
                © <?php echo e(date('Y')); ?> SIAC. Todos los derechos reservados.<br>
                Este mensaje fue enviado a <?php echo e($solicitud->email); ?>

            </p>
        </div>
    </div>
</body>
</html>
<?php /**PATH /var/www/html/siac/resources/views/emails/solicitud-creada.blade.php ENDPATH**/ ?>