<?php $__env->startSection('title', 'Tipo de Solicitudes'); ?>

<?php $__env->startPush('styles'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/admin.css']); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="admin-header">
        <h2 class="page-title">Listado de Tipos de Solicitudes</h2>
        <div class="d-flex justify-content-end">
            <a href="<?php echo e(route('admin.tipo-solicitudes.create')); ?>" class="btn btn-primary">
                Nuevo
                <i class="fas fa-plus me-1"></i> 
            </a>
        </div>
    </div>

    <div class="admin-responsive-table table-scroll-indicator">
        <table class="table table-hover mb-0">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nombre</th>
                    <th class="expandable-cell">Descripción</th>
                    <th>Estado</th>
                    <th class="text-center actions-cell" style="width: 150px;">Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $tipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($tipo->id); ?></td>
                        <td><?php echo e($tipo->denominacion); ?></td>
                        <td><?php echo e(Str::limit($tipo->descripcion, 50)); ?></td>
                        <td>
                            <span class="status-badge <?php echo e($tipo->activo ? 'status-active' : 'status-inactive'); ?>">
                                <?php echo e($tipo->activo ? 'Activo' : 'Inactivo'); ?>

                            </span>
                        </td>
                        <td class="text-center">
                            <div class="btn-actions">
                                <button type="button" class="btn btn-sm btn-outline-info" onclick="loadViewModal(<?php echo e($tipo->id); ?>)" title="Ver">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-warning" onclick="loadEditModal(<?php echo e($tipo->id); ?>)" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <form action="<?php echo e(route('admin.tipo-solicitudes.destroy', $tipo->id)); ?>" method="POST" class="d-inline delete-tipo-form">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-outline-danger" title="Eliminar">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="empty-state">
                            <i class="fas fa-inbox fa-2x mb-2 text-muted"></i>
                            <p class="mb-0">No hay tipos de solicitudes registrados.</p>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php echo $__env->make('components.dynamic-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        // Variables globales para JS
        window.successMessage = <?php echo json_encode(session('success'), 15, 512) ?>;
        window.errorMessage = <?php echo json_encode(session('error'), 15, 512) ?>;
        window.errorMessages = <?php echo json_encode($errors->any() ? implode('<br>', $errors->all()) : null, 512) ?>;
        window.tipoSolicitudesIndexRoute = "<?php echo e(route('admin.tipo-solicitudes.index')); ?>";
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin-tipos.js']); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/siac/resources/views/admin/tipo_solicitudes/index.blade.php ENDPATH**/ ?>