
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title><?php echo $__env->yieldContent('title', 'Sistema de Solicitudes'); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- Google Fonts: Inter -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <!-- Font Awesome para iconos -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="/css/root.css">
    <link rel="stylesheet" href="/css/app.css">
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body>
    <div>
        <?php echo $__env->yieldContent('content'); ?>
        
        
        <?php
            $toastScripts = [];
            if(session('success')) {
                $toastScripts[] = "showToast({text: " . json_encode(session('success')) . ", icon: 'success', timer: 4000});";
            }
            if(session('error')) {
                $toastScripts[] = "showToast({text: " . json_encode(session('error')) . ", icon: 'error', timer: 5000});";
            }
            // No procesar automáticamente $errors aquí, dejar que las vistas los manejen
        ?>
        <?php if(count($toastScripts)): ?>
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    <?php echo implode("\n                    ", $toastScripts); ?>

                });
            </script>
        <?php endif; ?>
    </div>
    <?php echo $__env->yieldContent('mirror-card'); ?>
    
    <!-- SweetAlert2 (para toast) -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="/js/toast-handler.js"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html><?php /**PATH /var/www/html/siac/resources/views/layouts/app.blade.php ENDPATH**/ ?>