<?php $__env->startSection('content'); ?>
<div class="mt-4">
    <h2 class="text-gray font-weight-bold mb-4">Solicitudes Ingresadas</h2>
    
    <?php echo $__env->make('admin.solicitudes.partials.filters', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    
    <div class="admin-responsive-table table-scroll-indicator">
        <table class="table table-hover align-middle table-sm">
            <thead class="thead-light">
                <tr>
                    <th class="text-center">#</th>
                    <th>Tipo</th>
                    <th class="expandable-cell">Organismo</th>
                    <th>Estado</th>
                    <th>Fecha</th>
                    <th class="text-center">Días</th>
                    <th>Gestor</th>
                    <th class="text-center actions-cell">Acciones</th>
                </tr>
            </thead>
        <tbody>
            <?php $__currentLoopData = $solicitudes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $solicitud): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="<?php echo e($solicitud->estado == 'cerrada' ? 'solicitud-cerrada' : ''); ?>">
                    <td class="text-center"><?php echo e($solicitud->id); ?></td>
                    <td><?php echo e($solicitud->tipoSolicitud->denominacion ?? '-'); ?></td>
                    <td><?php echo e($solicitud->organismoRequeridor->nombre ?? '-'); ?></td>
                    <td>
                        <?php echo $__env->make('admin.solicitudes.partials.estado-badge', ['solicitud' => $solicitud], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </td>
                    <td><?php echo e(\Carbon\Carbon::parse($solicitud->fecha_solicitud)->format('Y-m-d')); ?></td>
                    <td class="text-center">
                        <?php echo $__env->make('admin.solicitudes.partials.tiempo-restante', ['solicitud' => $solicitud], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </td>
                    <td><?php echo e($solicitud->gestor?->name ?? '-'); ?></td>
                    <td class="text-center">
                        <?php echo $__env->make('admin.solicitudes.partials.table-actions', ['solicitud' => $solicitud], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        <?php echo $__env->make('admin.solicitudes.partials.modal-resumen', ['solicitud' => $solicitud], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    </div>
    
    <div class="d-flex justify-content-between align-items-center mt-3">
        <div class="text-muted">
            <small>
                Mostrando <?php echo e($solicitudes->firstItem()); ?> - <?php echo e($solicitudes->lastItem()); ?> 
                de <?php echo e($solicitudes->total()); ?> solicitudes 
                (Página <?php echo e($solicitudes->currentPage()); ?> de <?php echo e($solicitudes->lastPage()); ?>)
            </small>
        </div>
        <div>
            <?php echo e($solicitudes->appends(request()->query())->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/solicitudes-index.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('js/solicitudes-index.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/siac/resources/views/admin/solicitudes/index.blade.php ENDPATH**/ ?>