<?php $__env->startSection('title', 'Crear Usuario'); ?>

<?php $__env->startPush('styles'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/admin-users-form.css']); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="user-form-card">
    <div class="user-form-header">
        <h3>Registrar Usuario</h3>
    </div>
    
    <div class="user-form-body">
        <?php if (isset($component)) { $__componentOriginalb24df6adf99a77ed35057e476f61e153 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb24df6adf99a77ed35057e476f61e153 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.validation-errors','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('validation-errors'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb24df6adf99a77ed35057e476f61e153)): ?>
<?php $attributes = $__attributesOriginalb24df6adf99a77ed35057e476f61e153; ?>
<?php unset($__attributesOriginalb24df6adf99a77ed35057e476f61e153); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb24df6adf99a77ed35057e476f61e153)): ?>
<?php $component = $__componentOriginalb24df6adf99a77ed35057e476f61e153; ?>
<?php unset($__componentOriginalb24df6adf99a77ed35057e476f61e153); ?>
<?php endif; ?>
        
        <form action="<?php echo e(route('admin.users.store')); ?>" method="POST" id="userForm">
            <?php echo csrf_field(); ?>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="first_name" class="form-label required">Nombres</label>
                        <input type="text" 
                               class="form-control" 
                               id="first_name" 
                               name="first_name" 
                               value="<?php echo e(old('first_name')); ?>"
                               required>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="last_name" class="form-label required">Apellidos</label>
                        <input type="text" 
                               class="form-control" 
                               id="last_name" 
                               name="last_name" 
                               value="<?php echo e(old('last_name')); ?>"
                               required>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="email" class="form-label required">Email</label>
                        <input type="email" 
                               class="form-control" 
                               id="email" 
                               name="email" 
                               value="<?php echo e(old('email')); ?>"
                               required>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="telefono" class="form-label">Teléfono</label>
                        <input type="text" 
                               class="form-control" 
                               id="telefono" 
                               name="telefono"
                               value="<?php echo e(old('telefono')); ?>">
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="role" class="form-label required">Rol</label>
                        <select class="form-control form-select" 
                                id="role" 
                                name="role" 
                                required>
                            <option value="">Seleccionar rol</option>
                            <option value="admin" <?php echo e(old('role') == 'admin' ? 'selected' : ''); ?>>Administrador</option>
                            <option value="moderador" <?php echo e(old('role') == 'moderador' ? 'selected' : ''); ?>>Moderador</option>
                            <option value="lectura" <?php echo e(old('role') == 'lectura' ? 'selected' : ''); ?>>Solo Lectura</option>
                        </select>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="organismo_id" class="form-label">Organismo</label>
                        <select class="form-control form-select" 
                                id="organismo_id" 
                                name="organismo_id">
                            <option value="">Sin organismo</option>
                            <?php $__currentLoopData = $organismos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organismo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($organismo->id); ?>" 
                                        <?php echo e(old('organismo_id') == $organismo->id ? 'selected' : ''); ?>>
                                    <?php echo e($organismo->nombre); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="password" class="form-label required">Contraseña</label>
                        <input type="password" 
                               class="form-control" 
                               id="password" 
                               name="password" 
                               required>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="password_confirmation" class="form-label required">Confirmar Contraseña</label>
                        <input type="password" 
                               class="form-control" 
                               id="password_confirmation" 
                               name="password_confirmation" 
                               required>
                    </div>
                </div>
            </div>
            
            <div class="form-buttons">
                <button type="submit" class="btn btn-submit">
                    <i class="fas fa-save"></i> Registrar Usuario
                </button>
                <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-cancel">
                    <i class="fas fa-arrow-left"></i> Volver
                </a>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin-users-form.js']); ?>
    <script>
        // Variables globales para el contexto
        window.successMessage = <?php echo json_encode(session('success'), 15, 512) ?>;
        window.errorMessage = <?php echo json_encode(session('error'), 15, 512) ?>;
        window.errorMessages = <?php echo json_encode($errors->any() ? implode('<br>', $errors->all()) : null, 512) ?>;
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/siac/resources/views/admin/users/create.blade.php ENDPATH**/ ?>