<?php $__env->startSection('content'); ?>
<div class="auth-card">
    <div class="auth-logo">
        <img src="<?php echo e(asset('images/logo.png')); ?>" alt="Logo SIAC">
        <div class="auth-title">Iniciar Sesión</div>
        <div class="auth-subtitle">Sistema Integral de Atención Ciudadana</div>
    </div>

    <?php if(session('success')): ?>
        <div class="auth-alert auth-alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="auth-alert auth-alert-error">
            <ul style="margin: 0; padding-left: 1.2rem;">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('login')); ?>" class="auth-form">
        <?php echo csrf_field(); ?>
        
        <div class="auth-form-group">
            <label for="email" class="auth-form-label">Email</label>
            <input 
                type="email" 
                class="auth-form-input <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                id="email" 
                name="email" 
                value="<?php echo e(old('email')); ?>" 
                required 
                autofocus
                placeholder="Ingrese su email"
            >
            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="invalid-feedback"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="auth-form-group">
            <label for="password" class="auth-form-label">Contraseña</label>
            <input 
                type="password" 
                class="auth-form-input <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                id="password" 
                name="password" 
                required
                placeholder="Ingrese su contraseña"
            >
            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="invalid-feedback"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="auth-form-checkbox">
            <input type="checkbox" id="remember" name="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
            <label for="remember">Recordarme</label>
        </div>

        <button type="submit" class="auth-btn">Ingresar</button>
    </form>

    <div class="auth-links">
        <small style="color: #6c757d; display: block; margin-top: 1.5rem; text-align: center;">
            SIAC &copy; <?php echo e(date('Y')); ?> - Municipalidad de Loncoche
        </small>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/siac/resources/views/auth/login.blade.php ENDPATH**/ ?>