
<div class="card shadow-sm border-0">
    <div class="card-header bg-info text-white">
        <h6 class="mb-0"><i class="fas fa-paperclip mr-2"></i>Evidencias</h6>
    </div>
    <div class="card-body p-2">
        <?php
            $evidencias = [];
            if($solicitud->uri_evidencia && file_exists($solicitud->uri_evidencia)) {
                $evidenciaPath = $solicitud->uri_evidencia;
                if (is_dir($evidenciaPath)) {
                    $scanFiles = scandir($evidenciaPath);
                    foreach ($scanFiles as $file) {
                        if ($file !== '.' && $file !== '..' && is_file($evidenciaPath . '/' . $file)) {
                            $fullPath = $evidenciaPath . '/' . $file;
                            $evidencias[] = [
                                'name' => $file,
                                'size' => filesize($fullPath),
                                'extension' => strtolower(pathinfo($file, PATHINFO_EXTENSION)),
                                'download_url' => route('admin.solicitudes.download-evidencia', [
                                    'id' => $solicitud->id,
                                    'filename' => $file
                                ])
                            ];
                        }
                    }
                }
            }
        ?>

        <?php if(count($evidencias) > 0): ?>
            <div class="evidencias-list">
                <?php $__currentLoopData = $evidencias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evidencia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="evidencia-item mb-2 p-2 border rounded bg-white">
                    <div class="d-flex align-items-center">
                        <div class="evidencia-icon mr-2">
                            <?php if(in_array($evidencia['extension'], ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp'])): ?>
                                <i class="fas fa-file-image text-success"></i>
                            <?php elseif(in_array($evidencia['extension'], ['pdf'])): ?>
                                <i class="fas fa-file-pdf text-danger"></i>
                            <?php elseif(in_array($evidencia['extension'], ['doc', 'docx'])): ?>
                                <i class="fas fa-file-word text-primary"></i>
                            <?php elseif(in_array($evidencia['extension'], ['xls', 'xlsx'])): ?>
                                <i class="fas fa-file-excel text-success"></i>
                            <?php elseif(in_array($evidencia['extension'], ['txt'])): ?>
                                <i class="fas fa-file-alt text-muted"></i>
                            <?php else: ?>
                                <i class="fas fa-file text-muted"></i>
                            <?php endif; ?>
                        </div>
                        <div class="evidencia-info flex-grow-1">
                            <div class="evidencia-name small font-weight-bold" title="<?php echo e($evidencia['name']); ?>">
                                <?php echo e(Str::limit($evidencia['name'], 25)); ?>

                            </div>
                            <div class="evidencia-meta text-muted" style="font-size: 0.75rem;">
                                <?php echo e(number_format($evidencia['size'] / 1024, 1)); ?> KB
                            </div>
                        </div>
                    </div>
                    <div class="evidencia-actions mt-2">
                        <a href="<?php echo e($evidencia['download_url']); ?>" 
                           class="btn btn-sm btn-outline-primary btn-block" 
                           title="Descargar <?php echo e($evidencia['name']); ?>">
                            <i class="fas fa-download mr-1"></i>Descargar
                        </a>
                        <?php if(in_array($evidencia['extension'], ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp'])): ?>
                        <button type="button" 
                                class="btn btn-sm btn-outline-info btn-block mt-1"
                                onclick="previewImage('<?php echo e($evidencia['download_url']); ?>', '<?php echo e($evidencia['name']); ?>')"
                                title="Vista previa">
                            <i class="fas fa-eye mr-1"></i>Vista previa
                        </button>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <div class="text-center text-muted py-4">
                <i class="fas fa-folder-open fa-2x mb-2"></i>
                <div>No hay evidencias adjuntas</div>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /var/www/html/siac/resources/views/admin/solicitudes/partials/modal-evidencias.blade.php ENDPATH**/ ?>