<?php $__env->startSection('title', 'Dashboard Administrativo'); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .dashboard-card {
            transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
            border: none;
            border-radius: 12px;
            overflow: hidden;
        }

        .dashboard-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
        }

        .stats-card {
            background: #6c757d;
            color: white;
            position: relative;
            overflow: hidden;
        }

        .stats-card.consolidated {
            background: #6c757d;
        }

        .stats-card.success {
            background: #52a968;
        }

        .stats-card.warning {
            background: #e6a85c;
        }

        .stats-card.danger {
            background: #d9746a;
        }

        .stats-card.info {
            background: #6db4c4;
        }

        .stats-card::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100px;
            height: 100px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            transform: translate(30px, -30px);
        }

        .stats-number {
            font-size: 2.5rem;
            font-weight: 700;
            line-height: 1;
        }

        .stats-label {
            font-size: 0.9rem;
            opacity: 0.9;
            margin-bottom: 0;
        }

        .stats-icon {
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 2rem;
            opacity: 0.3;
        }

        .section-title {
            color: #495057;
            font-weight: 600;
            margin-bottom: 1.5rem;
            position: relative;
            padding-left: 20px;
        }

        .section-title::before {
            content: '';
            position: absolute;
            left: 0;
            top: 50%;
            transform: translateY(-50%);
            width: 4px;
            height: 24px;
            background: #6c757d;
            border-radius: 2px;
        }

        .table-responsive {
            border-radius: 12px;
            overflow: hidden;
        }

        .table thead th {
            background: #f8f9fa;
            border: none;
            font-weight: 600;
            color: #495057;
            padding: 1rem 0.75rem;
        }

        .badge-status {
            padding: 0.5rem 0.75rem;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 500;
        }

        .chart-container {
            position: relative;
            height: 300px;
            padding: 20px;
        }

        .urgente-item {
            border-left: 4px solid #d9746a;
            background: rgba(217, 116, 106, 0.1);
        }

        /* Estilos para tabla responsive con scroll horizontal */
        .table-responsive-scroll {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .table-responsive-scroll::-webkit-scrollbar {
            height: 8px;
        }

        .table-responsive-scroll::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 4px;
        }

        .table-responsive-scroll::-webkit-scrollbar-thumb {
            background: #888;
            border-radius: 4px;
        }

        .table-responsive-scroll::-webkit-scrollbar-thumb:hover {
            background: #555;
        }

        .table-urgentes {
            min-width: 800px; /* Ancho mínimo para evitar que se comprima demasiado */
            margin-bottom: 0;
        }

        .table-urgentes th,
        .table-urgentes td {
            white-space: nowrap;
            padding: 0.75rem 0.5rem;
        }

        .table-urgentes .organismo-col {
            max-width: 150px;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .table-urgentes .gestor-col {
            max-width: 120px;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        @media (max-width: 768px) {
            .table-urgentes th,
            .table-urgentes td {
                padding: 0.5rem 0.25rem;
                font-size: 0.85rem;
            }
            
            .table-urgentes .organismo-col {
                max-width: 100px;
            }
            
            .table-urgentes .gestor-col {
                max-width: 80px;
            }
        }

        .gestor-ranking {
            display: flex;
            align-items: center;
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 0.5rem;
            background: #f8f9fa;
            transition: background 0.2s ease;
        }

        .gestor-ranking:hover {
            background: #e9ecef;
        }

        .ranking-number {
            background: #6c757d;
            color: white;
            width: 30px;
            height: 30px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            margin-right: 1rem;
            font-size: 0.9rem;
        }

        /* Estilos para los elementos mejorados del dashboard */
        .organismo-item,
        .tipo-solicitud-item {
            background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
            transition: all 0.3s ease;
            border: 1px solid #e9ecef;
        }

        .organismo-item:hover,
        .tipo-solicitud-item:hover {
            background: linear-gradient(135deg, #e3f2fd 0%, #f8f9fa 100%);
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        .badge.bg-gradient-primary {
            background: linear-gradient(45deg, #007bff, #0056b3) !important;
            box-shadow: 0 2px 5px rgba(0, 123, 255, 0.3);
        }

        .badge.bg-gradient-info {
            background: linear-gradient(45deg, #17a2b8, #138496) !important;
            box-shadow: 0 2px 5px rgba(23, 162, 184, 0.3);
        }

        .progress {
            background-color: #e9ecef;
            border-radius: 4px;
            overflow: hidden;
        }

        .progress-bar.bg-info {
            background: linear-gradient(90deg, #17a2b8, #20c997) !important;
            transition: width 0.6s ease;
        }

        .border-start.border-3.border-info {
            border-left-color: #17a2b8 !important;
        }

        .border-start.border-3.border-primary {
            border-left-color: #007bff !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h1 class="h3 mb-0 text-gray-800">Dashboard Administrativo</h1>
                <p class="mb-0 text-muted">Resumen general del sistema de solicitudes</p>
            </div>
            <div class="text-muted">
                <i class="fas fa-calendar-alt"></i> <?php echo e(now(-4)->format('d/m/Y H:i')); ?>

            </div>
        </div>

        <!-- Estadísticas Principales -->
        <div class="row mb-4">
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card dashboard-card stats-card consolidated">
                    <div class="card-body">
                        <div class="stats-icon">
                            <i class="fas fa-clipboard-list"></i>
                        </div>
                        <div class="stats-number"><?php echo e($estadisticas['total']); ?></div>
                        <p class="stats-label">Total de Solicitudes</p>
                        <small class="d-block mt-2">
                            <i class="fas fa-calendar-day"></i> Hoy: <?php echo e($estadisticas['hoy']); ?>

                        </small>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card dashboard-card stats-card warning">
                    <div class="card-body">
                        <div class="stats-icon">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div class="stats-number"><?php echo e($estadisticas['pendientes']); ?></div>
                        <p class="stats-label">Pendientes</p>
                        <small class="d-block mt-2">
                            <i class="fas fa-calendar-week"></i> Esta semana: <?php echo e($estadisticas['esta_semana']); ?>

                        </small>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card dashboard-card stats-card info">
                    <div class="card-body">
                        <div class="stats-icon">
                            <i class="fas fa-cogs"></i>
                        </div>
                        <div class="stats-number"><?php echo e($estadisticas['en_gestion']); ?></div>
                        <p class="stats-label">En Gestión</p>
                        <small class="d-block mt-2">
                            <i class="fas fa-calendar"></i> Este mes: <?php echo e($estadisticas['este_mes']); ?>

                        </small>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card dashboard-card stats-card success">
                    <div class="card-body">
                        <div class="stats-icon">
                            <i class="fas fa-check-circle"></i>
                        </div>
                        <div class="stats-number"><?php echo e($estadisticas['cerradas']); ?></div>
                        <p class="stats-label">Cerradas</p>
                        <small class="d-block mt-2">
                            <i class="fas fa-chart-line"></i> Promedio: <?php echo e($tiempoPromedioResolucion); ?> días
                        </small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Gráfico de Tendencias y Estado -->
        <div class="row mb-4">
            <div class="col-lg-8">
                <div class="card dashboard-card">
                    <div class="card-header bg-white border-0">
                        <h5 class="section-title mb-0">Tendencia de Solicitudes (Últimos 7 días)</h5>
                    </div>
                    <div class="card-body">
                        <div class="chart-container">
                            <canvas id="tendenciaChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card dashboard-card">
                    <div class="card-header bg-white border-0">
                        <h5 class="section-title mb-0">Estado de Solicitudes</h5>
                    </div>
                    <div class="card-body">
                        <div class="chart-container">
                            <canvas id="estadoChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Solicitudes Urgentes y Top Gestores -->
        <div class="row mb-4">
            <div class="col-lg-8">
                <div class="card dashboard-card">
                    <div class="card-header bg-white border-0">
                        <h5 class="section-title mb-0">
                            <i class="fas fa-exclamation-triangle text-danger me-2"></i>
                            Solicitudes Urgentes
                        </h5>
                    </div>
                    <div class="card-body">
                        <?php if($solicitudesUrgentes->count() > 0): ?>
                            <div class="table-responsive-scroll">
                                <table class="table table-hover table-urgentes">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Tipo</th>
                                            <th class="organismo-col">Organismo</th>
                                            <th class="gestor-col">Gestor</th>
                                            <th>Estado</th>
                                            <th>Tiempo</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $solicitudesUrgentes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $solicitud): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $limite = $solicitud->fecha_asignacion ?? $solicitud->created_at;
                                                $horasLimite = $solicitud->tiempo_limite_horas ?? 168;
                                                $fechaLimite = \Carbon\Carbon::parse($limite)->addHours($horasLimite);
                                                $horasRestantes = now()->diffInHours($fechaLimite, false);
                                                $vencida = $fechaLimite->isPast();
                                                
                                                // Formatear tiempo de manera más legible
                                                if ($vencida) {
                                                    $tiempoTexto = 'Vencida';
                                                    $tiempoClase = 'text-danger fw-bold';
                                                    $tiempoIcono = 'fas fa-exclamation-circle';
                                                } else {
                                                    $dias = floor(abs($horasRestantes) / 24);
                                                    $horas = abs($horasRestantes) % 24;
                                                    
                                                    if ($dias > 0) {
                                                        $tiempoTexto = $dias . 'd ' . $horas . 'h';
                                                    } else {
                                                        $tiempoTexto = $horas . 'h';
                                                    }
                                                    
                                                    $tiempoClase = $horasRestantes <= 24 ? 'text-warning fw-bold' : 'text-warning';
                                                    $tiempoIcono = $horasRestantes <= 24 ? 'fas fa-clock' : 'fas fa-hourglass-half';
                                                }
                                            ?>
                                            <tr class="<?php if($vencida): ?> urgente-item <?php endif; ?>">
                                                <td><strong>#<?php echo e($solicitud->id); ?></strong></td>
                                                <td title="<?php echo e($solicitud->tipoSolicitud->denominacion ?? 'N/A'); ?>">
                                                    <?php echo e(Str::limit($solicitud->tipoSolicitud->denominacion ?? 'N/A', 15)); ?>

                                                </td>
                                                <td class="organismo-col" title="<?php echo e($solicitud->organismoRequeridor->nombre ?? 'N/A'); ?>">
                                                    <?php echo e(Str::limit($solicitud->organismoRequeridor->nombre ?? 'N/A', 20)); ?>

                                                </td>
                                                <td class="gestor-col" title="<?php echo e($solicitud->gestor->name ?? 'Sin asignar'); ?>">
                                                    <?php echo e(Str::limit($solicitud->gestor->name ?? 'Sin asignar', 15)); ?>

                                                </td>
                                                <td>
                                                    <span class="badge badge-status 
                                                            <?php if($solicitud->estado == 'pendiente'): ?> bg-warning
                                                            <?php elseif($solicitud->estado == 'en_gestion'): ?> bg-info
                                                            <?php else: ?> bg-success <?php endif; ?>">
                                                        <?php if($solicitud->estado == 'pendiente'): ?> Pendiente
                                                        <?php elseif($solicitud->estado == 'en_gestion'): ?> En gestión
                                                        <?php else: ?> <?php echo e(ucfirst(str_replace('_', ' ', $solicitud->estado))); ?>

                                                        <?php endif; ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <span class="<?php echo e($tiempoClase); ?>">
                                                        <i class="<?php echo e($tiempoIcono); ?>"></i> <?php echo e($tiempoTexto); ?>

                                                    </span>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                            <!-- Indicador de scroll para móviles -->
                            <div class="d-block d-md-none mt-2">
                                <small class="text-muted">
                                    <i class="fas fa-arrows-alt-h"></i> Desliza horizontalmente para ver más columnas
                                </small>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-4">
                                <i class="fas fa-check-circle text-success" style="font-size: 3rem;"></i>
                                <h5 class="mt-3 text-muted">No hay solicitudes urgentes</h5>
                                <p class="text-muted">Todas las solicitudes están dentro de los tiempos normales</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card dashboard-card">
                    <div class="card-header bg-white border-0">
                        <h5 class="section-title mb-0">
                            <i class="fas fa-trophy text-warning me-2"></i>
                            Top Gestores
                        </h5>
                    </div>
                    <div class="card-body">
                        <?php $__currentLoopData = $topGestores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $gestor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="gestor-ranking">
                                <div class="ranking-number"><?php echo e($index + 1); ?></div>
                                <div class="flex-grow-1">
                                    <h6 class="mb-1"><?php echo e($gestor->name); ?></h6>
                                    <small class="text-muted">
                                        <i class="fas fa-tasks"></i> <?php echo e($gestor->activas); ?> activas |
                                        <i class="fas fa-check"></i> <?php echo e($gestor->cerradas); ?> cerradas
                                    </small>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Últimas Solicitudes y Estadísticas Adicionales -->
        <div class="row">
            <div class="col-lg-8">
                <div class="card dashboard-card">
                    <div class="card-header bg-white border-0">
                        <h5 class="section-title mb-0">Últimas Solicitudes</h5>
                    </div>
                    <div class="card-body">
                        <div class="admin-responsive-table table-scroll-indicator">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Tipo</th>
                                        <th class="expandable-cell">Organismo</th>
                                        <th>Estado</th>
                                        <th>Fecha</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $ultimasSolicitudes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $solicitud): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><strong>#<?php echo e($solicitud->id); ?></strong></td>
                                            <td><?php echo e($solicitud->tipoSolicitud->denominacion ?? 'N/A'); ?></td>
                                            <td><?php echo e(Str::limit($solicitud->organismoRequeridor->nombre ?? 'N/A', 30)); ?></td>
                                            <td>
                                                <span class="badge badge-status 
                                                    <?php if($solicitud->estado == 'pendiente'): ?> bg-warning
                                                    <?php elseif($solicitud->estado == 'en_gestion'): ?> bg-info
                                                    <?php else: ?> bg-success <?php endif; ?>">
                                                    <?php echo e(ucfirst(str_replace('_', ' ', $solicitud->estado))); ?>

                                                </span>
                                            </td>
                                            <td><?php echo e($solicitud->created_at->format('d/m/Y H:i')); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="row">
                    <div class="col-12 mb-4">
                        <div class="card dashboard-card">
                            <div class="card-header bg-white border-0">
                                <h6 class="section-title mb-0">
                                    <i class="fas fa-list-alt text-primary me-2"></i>
                                    Tipos de Solicitud Más Comunes
                                </h6>
                            </div>
                            <div class="card-body">
                                <?php $__empty_1 = true; $__currentLoopData = $tiposSolicitudComunes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="tipo-solicitud-item mb-3 p-2 rounded border-start border-3 border-primary">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div class="flex-grow-1">
                                                <h6 class="mb-1 fw-bold"><?php echo e(Str::limit($tipo->denominacion, 25)); ?></h6>
                                                <small class="text-muted">
                                                    <i class="fas fa-file-alt text-primary"></i> 
                                                    <?php echo e($tipo->total_solicitudes); ?> solicitudes registradas
                                                </small>
                                            </div>
                                            <div class="text-end">
                                                <span class="badge bg-gradient-primary fs-6"><?php echo e($tipo->total_solicitudes); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="text-center py-3">
                                        <i class="fas fa-list-alt text-muted fa-2x mb-2"></i>
                                        <p class="text-muted mb-0">No hay tipos de solicitud registrados</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="card dashboard-card">
                            <div class="card-header bg-white border-0">
                                <h6 class="section-title mb-0">
                                    <i class="fas fa-building text-info me-2"></i>
                                    Organismos Más Activos
                                </h6>
                            </div>
                            <div class="card-body">
                                <?php $__empty_1 = true; $__currentLoopData = $organismosActivos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organismo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="organismo-item mb-3 p-2 rounded border-start border-3 border-info">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <div class="flex-grow-1">
                                                <h6 class="mb-1 fw-bold"><?php echo e(Str::limit($organismo->nombre, 25)); ?></h6>
                                                <div class="d-flex gap-2 mb-2">
                                                    <small class="text-muted">
                                                        <i class="fas fa-tasks text-warning"></i> 
                                                        <?php echo e($organismo->activas); ?> activas
                                                    </small>
                                                    <small class="text-muted">
                                                        <i class="fas fa-chart-line text-primary"></i> 
                                                        <?php echo e($organismo->total_solicitudes); ?> total
                                                    </small>
                                                </div>
                                            </div>
                                            <div class="text-end">
                                                <span class="badge bg-gradient-info fs-6"><?php echo e($organismo->activas); ?></span>
                                            </div>
                                        </div>
                                        
                                        <!-- Progress bar para mostrar proporción de activas vs total -->
                                        <?php
                                            $porcentajeActivas = $organismo->total_solicitudes > 0 
                                                ? round(($organismo->activas / $organismo->total_solicitudes) * 100) 
                                                : 0;
                                        ?>
                                        <div class="progress mt-2" style="height: 4px;">
                                            <div class="progress-bar bg-info" 
                                                 role="progressbar" 
                                                 style="width: <?php echo e($porcentajeActivas); ?>%"
                                                 aria-valuenow="<?php echo e($porcentajeActivas); ?>" 
                                                 aria-valuemin="0" 
                                                 aria-valuemax="100">
                                            </div>
                                        </div>
                                        <small class="text-muted">
                                            <?php echo e($porcentajeActivas); ?>% de solicitudes están activas
                                        </small>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="text-center py-3">
                                        <i class="fas fa-building text-muted fa-2x mb-2"></i>
                                        <p class="text-muted mb-0">No hay organismos con solicitudes activas</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Gráfico de tendencias
            const tendenciaCtx = document.getElementById('tendenciaChart').getContext('2d');
            new Chart(tendenciaCtx, {
                type: 'line',
                data: {
                    labels: <?php echo json_encode($tendenciaSolicitudes['fechas'], 15, 512) ?>,
                    datasets: [{
                        label: 'Solicitudes',
                        data: <?php echo json_encode($tendenciaSolicitudes['datos'], 15, 512) ?>,
                        borderColor: '#007bff',
                        backgroundColor: 'rgba(0, 123, 255, 0.1)',
                        borderWidth: 3,
                        fill: true,
                        tension: 0.4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            grid: {
                                color: 'rgba(0,0,0,0.1)'
                            }
                        },
                        x: {
                            grid: {
                                display: false
                            }
                        }
                    }
                }
            });

            // Gráfico de estado
            const estadoCtx = document.getElementById('estadoChart').getContext('2d');
            const estadosData = <?php echo json_encode($estadisticasPorEstado, 15, 512) ?>;

            new Chart(estadoCtx, {
                type: 'doughnut',
                data: {
                    labels: Object.keys(estadosData).map(estado =>
                        estado.charAt(0).toUpperCase() + estado.slice(1).replace('_', ' ')
                    ),
                    datasets: [{
                        data: Object.values(estadosData),
                        backgroundColor: [
                            '#ffc107',
                            '#17a2b8',
                            '#28a745',
                            '#dc3545'
                        ],
                        borderWidth: 0
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                padding: 20,
                                usePointStyle: true
                            }
                        }
                    }
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/siac/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>