<?php $__env->startSection('title', 'Datos Estadísticos'); ?>

<?php $__env->startSection('content'); ?>
<div class="siac-app-card siac-view-statistics" style="margin-bottom: 6rem;">
  <!-- Formulario -->
  <form class="siac-form" action="<?php echo e(route('solicitudes.storeStatistics')); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <div class="siac-form-label-title" style="margin-bottom:1.5rem;">Datos Estadísticos (Opcional)</div>
    
    <label class="siac-form-label" for="tipo_zona">Tipo de Zona</label>
    <select name="tipo_zona" id="tipo_zona" class="siac-form-select">
      <option value="">Sin Información</option>
      <option value="Urbana" <?php echo e(old('tipo_zona') == 'Urbana' ? 'selected' : ''); ?>>Urbana</option>
      <option value="Rural" <?php echo e(old('tipo_zona') == 'Rural' ? 'selected' : ''); ?>>Rural</option>
    </select>

    <label class="siac-form-label" for="educacion">Educación</label>
    <select name="educacion" id="educacion" class="siac-form-select">
      <option value="">Sin Información</option>
      <option value="Básica" <?php echo e(old('educacion') == 'Básica' ? 'selected' : ''); ?>>Básica</option>
      <option value="Media" <?php echo e(old('educacion') == 'Media' ? 'selected' : ''); ?>>Media</option>
      <option value="Técnica" <?php echo e(old('educacion') == 'Técnica' ? 'selected' : ''); ?>>Técnica</option>
      <option value="Universitaria" <?php echo e(old('educacion') == 'Universitaria' ? 'selected' : ''); ?>>Universitaria</option>
      <option value="Postgrado" <?php echo e(old('educacion') == 'Postgrado' ? 'selected' : ''); ?>>Postgrado</option>
    </select>

    <label class="siac-form-label" for="usuario_respuesta">Medio de Respuesta</label>
    <select name="usuario_respuesta" id="usuario_respuesta" class="siac-form-select">
      <option value="">Seleccione una opción</option>
      <option value="Carta Certificada" <?php echo e(old('usuario_respuesta') == 'Carta Certificada' ? 'selected' : ''); ?>>Carta Certificada</option>
      <option value="Email" <?php echo e(old('usuario_respuesta') == 'Email' ? 'selected' : ''); ?>>Email</option>
      <option value="Retiro en oficina" <?php echo e(old('usuario_respuesta') == 'Retiro en oficina' ? 'selected' : ''); ?>>Retiro en oficina</option>
    </select>

    <label class="siac-form-label" for="edad">Edad</label>
    <select name="edad" id="edad" class="siac-form-select">
      <option value="">Sin Información</option>
      <?php for($i = 18; $i <= 100; $i++): ?>
        <option value="<?php echo e($i); ?>" <?php echo e(old('edad') == $i ? 'selected' : ''); ?>><?php echo e($i); ?></option>
      <?php endfor; ?>
    </select>

    <label class="siac-form-label" for="ocupacion">Ocupación</label>
    <select name="ocupacion" id="ocupacion" class="siac-form-select">
      <option value="">Sin Información</option>
      <option value="Estudiante" <?php echo e(old('ocupacion') == 'Estudiante' ? 'selected' : ''); ?>>Estudiante</option>
      <option value="Trabajador Dependiente" <?php echo e(old('ocupacion') == 'Trabajador Dependiente' ? 'selected' : ''); ?>>Trabajador Dependiente</option>
      <option value="Trabajador Independiente" <?php echo e(old('ocupacion') == 'Trabajador Independiente' ? 'selected' : ''); ?>>Trabajador Independiente</option>
      <option value="Empresario" <?php echo e(old('ocupacion') == 'Empresario' ? 'selected' : ''); ?>>Empresario</option>
      <option value="Jubilado/Pensionado" <?php echo e(old('ocupacion') == 'Jubilado/Pensionado' ? 'selected' : ''); ?>>Jubilado/Pensionado</option>
      <option value="Desempleado" <?php echo e(old('ocupacion') == 'Desempleado' ? 'selected' : ''); ?>>Desempleado</option>
      <option value="Dueña de Casa" <?php echo e(old('ocupacion') == 'Dueña de Casa' ? 'selected' : ''); ?>>Dueña de Casa</option>
    </select>

    <label class="siac-form-label" for="genero">Género</label>
    <select name="genero" id="genero" class="siac-form-select">
      <option value="">Sin Información</option>
      <option value="Masculino" <?php echo e(old('genero') == 'Masculino' ? 'selected' : ''); ?>>Masculino</option>
      <option value="Femenino" <?php echo e(old('genero') == 'Femenino' ? 'selected' : ''); ?>>Femenino</option>
      <option value="Otro" <?php echo e(old('genero') == 'Otro' ? 'selected' : ''); ?>>Otro</option>
      <option value="Prefiero no decir" <?php echo e(old('genero') == 'Prefiero no decir' ? 'selected' : ''); ?>>Prefiero no decir</option>
    </select>

    <label class="siac-form-label" for="organizacion">Organización (Opcional)</label>
    <input type="text" name="organizacion" id="organizacion" class="siac-form-input" value="<?php echo e(old('organizacion')); ?>">

    <label class="siac-form-label" for="apoderado">Representa a (Opcional)</label>
    <input type="text" name="apoderado" id="apoderado" class="siac-form-input" value="<?php echo e(old('apoderado')); ?>">

    <button type="submit" class="siac-form-btn">Continuar</button>
  </form>

  <!-- Panel Institucional -->
  <div class="siac-info-panel">
    <img src="/images/logo.png" alt="Logo Municipalidad de Loncoche" class="logo-muni">
    <div class="siac-info-title">Municipalidad de Loncoche</div>
    <div class="siac-info-subtitle">Sistema de Información y Atención Ciudadana</div>
    <div class="siac-info-desc">
      Estos datos estadísticos son opcionales y nos ayudan a mejorar nuestros servicios y generar estadísticas para la gestión municipal. La información proporcionada será tratada de forma confidencial.
    </div>
    <img src="/images/logo-copihue.png" alt="Loncoche" class="siac-info-img">
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('mirror-card'); ?>
<div class="siac-view-statistics">
  <?php echo $__env->make('components.mirror_card', ['mirrorStep' => 'statistics'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/siac/resources/views/solicitudes/create_statistics.blade.php ENDPATH**/ ?>