import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import fullReload from 'vite-plugin-full-reload';
import { resolve } from 'path';

export default defineConfig({
    plugins: [
        laravel({
            input: [
                'resources/css/app.css', 
                'resources/js/app.js',
                // CSS específicos del admin
                'resources/css/admin.css',
                'resources/css/admin-dashboard.css',
                'resources/css/admin-organismos.css',
                'resources/css/admin-organismos-form.css',
                'resources/css/admin-solicitudes.css',
                'resources/css/admin-users.css',
                'resources/css/admin-users-form.css',
                'resources/css/admin-404.css',
                // JS específicos del admin
                'resources/js/admin-dashboard.js',
                'resources/js/admin-organismos.js',
                'resources/js/admin-organismos-form.js',
                'resources/js/admin-solicitudes.js',
                'resources/js/admin-tipos.js',
                'resources/js/admin-tipos-form.js',
                'resources/js/admin-users.js',
                'resources/js/admin-users-form.js',
                'resources/js/admin-404.js'
            ],
            refresh: true,
        }),
        fullReload(['resources/views/**/*.blade.php']),
    ],
    resolve: {
        alias: {
            '@': resolve(__dirname, 'resources'),
        },
    },
});
