document.addEventListener("DOMContentLoaded", () => {
  verificarSesion()
    .then((autenticado) => {
      if (autenticado) {
        const rol = sessionStorage.getItem('rol');
        const btnCrear = document.getElementById('btnCrearAdmin');

        if (rol === 'superadmin') {
          btnCrear.style.display = 'block';
        } else {
          alert("Acceso denegado. Solo el superadmin puede acceder.");
          window.location.href = "https://muniloncochedigital.cl/tto/";
        }
      } else {
        window.location.href = "https://muniloncochedigital.cl/tto/"; 
      }
    })
    .catch(() => {
      window.location.href = "https://muniloncochedigital.cl/tto/";
    });

  const form = document.getElementById('formAgregarAdmin');
  form.addEventListener('submit', async (e) => {
    e.preventDefault();
  
    const usuario = document.getElementById('usuario').value;
    const correo = document.getElementById('correo').value;
    const contrasena = document.getElementById('contrasena').value;
  
    try {
      const response = await fetch('../agregar/agregar_admin.php', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify({
          usuario: usuario,
          correo: correo,
          contrasena: contrasena,
          rol: 'admin'
        })
      });
  
      const data = await response.json();
  
      if (data.success) {
        alert("Administrador creado correctamente.");
        form.reset();
        window.location.href = "../dashboard.html";
      } else {
        alert("Error al crear el administrador: " + (data.error || data.mensaje || ''));
      }
    } catch (error) {
      console.error("Error:", error);
      alert("Ocurrió un error al enviar los datos.");
    }
  });

  async function verificarSesion() {
    try {
      const res = await fetch("../include/auth_check.php");
      if (!res.ok) return false;
      const data = await res.json();

      if (data.usuario && data.rol) {
        sessionStorage.setItem("usuario", data.usuario);
        sessionStorage.setItem("rol", data.rol);
        return true;
      }

      return false;
    } catch (e) {
      return false;
    }
  }
});
