<?php
include("../../conexion.php");
header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

if (!isset($_SESSION['rol']) || $_SESSION['rol'] !== 'superadmin') {
    http_response_code(403);
    echo json_encode(["status" => "error", "message" => "Acceso denegado"]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(["status" => "error", "message" => "Método no permitido"]);
    exit;
}

function getPost($key, $default = '') {
    return filter_input(INPUT_POST, $key) ?? $default;
}

$conexion->begin_transaction();

try {
    $input = json_decode(file_get_contents("php://input"), true);
    $usuario = trim($input['usuario'] ?? '');
    $correo = trim($input['correo'] ?? '');
    $contrasena = trim($input['contrasena'] ?? '');
    $rol         = 'admin';

    if (empty($usuario) || empty($correo) || empty($contrasena)) {
        throw new Exception("Faltan datos obligatorios");
    }

    $hashedPassword = password_hash($contrasena, PASSWORD_DEFAULT);

    $sql = "INSERT INTO administrador (usuario, correo, contrasena, rol)
            VALUES (?, ?, ?, ?)";

    $stmt = $conexion->prepare($sql);
    $stmt->bind_param("ssss", $usuario, $correo, $hashedPassword, $rol);

    $stmt->execute();
    $stmt->close();

    $conexion->commit();

    echo json_encode(["success" => true, "mensaje" => "Administrador creado exitosamente"]);

} catch (Exception $e) {
    $conexion->rollback();
    echo json_encode(["success" => false, "error" => "Error al guardar: " . $e->getMessage()]);
} finally {
    $conexion->close();
}
?>
