<?php
// Configuración de errores (comentar en producción)
error_reporting(E_ALL);
ini_set('display_errors', 0); // No mostrar en pantalla
ini_set('log_errors', 1);
ini_set('error_log', '/tmp/api-errors.log');

// IMPORTANTE: Header JSON debe ir ANTES de session_start()
header('Content-Type: application/json; charset=utf-8');

// Iniciar sesión
session_start();

// Incluir conexión
try {
    include("../conexion.php");
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "mensaje" => "Error de conexión a la base de datos"
    ]);
    exit;
}

// Verificar que conexión existe
if (!isset($conexion) || $conexion->connect_error) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "mensaje" => "No se pudo conectar a la base de datos"
    ]);
    exit;
}

// Verificar que existe el parámetro action
if (!isset($_GET['action'])) {
    http_response_code(400);
    echo json_encode([
        "success" => false,
        "mensaje" => "Acción no especificada"
    ]);
    exit;
}

// Procesar login
if ($_GET['action'] == 'login') {
    try {
        // Obtener y validar datos JSON
        $json = file_get_contents('php://input');
        $data = json_decode($json, true);
        
        // Validar que se recibieron datos
        if (!$data || !isset($data['correo']) || !isset($data['contrasena'])) {
            http_response_code(400);
            echo json_encode([
                "success" => false,
                "mensaje" => "Datos incompletos. Se requiere correo y contraseña."
            ]);
            exit;
        }
        
        $correo = trim($data['correo']);
        $contrasena = $data['contrasena'];
        
        // Validar que no estén vacíos
        if (empty($correo) || empty($contrasena)) {
            http_response_code(400);
            echo json_encode([
                "success" => false,
                "mensaje" => "El correo y la contraseña no pueden estar vacíos."
            ]);
            exit;
        }
        
        // Preparar consulta
        $sql = "SELECT * FROM administrador WHERE correo = ?";
        $stmt = $conexion->prepare($sql);
        
        if (!$stmt) {
            throw new Exception("Error al preparar consulta: " . $conexion->error);
        }
        
        $stmt->bind_param("s", $correo);
        $stmt->execute();
        $resultado = $stmt->get_result();
        
        // Verificar si existe el usuario
        if ($resultado && $resultado->num_rows > 0) {
            $row = $resultado->fetch_assoc();
            
            // Verificar contraseña
            if (password_verify($contrasena, $row['contrasena'])) {
                // Login exitoso
                $_SESSION["usuario"] = $row['correo'];
                $_SESSION["rol"] = $row['rol'];
                
                http_response_code(200);
                echo json_encode([
                    "success" => true,
                    "rol" => $row['rol'],
                    "usuario" => $row['correo']
                ]);
            } else {
                // Contraseña incorrecta
                http_response_code(401);
                echo json_encode([
                    "success" => false,
                    "mensaje" => "Contraseña incorrecta."
                ]);
            }
        } else {
            // Usuario no encontrado
            http_response_code(401);
            echo json_encode([
                "success" => false,
                "mensaje" => "Usuario no encontrado."
            ]);
        }
        
        $stmt->close();
        
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            "success" => false,
            "mensaje" => "Error del servidor: " . $e->getMessage()
        ]);
    }
    
    exit;
}

// Si la acción no existe
http_response_code(400);
echo json_encode([
    "success" => false,
    "mensaje" => "Acción no válida"
]);
exit;
?>