<?php
ob_start();

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once('fpdf/fpdf.php');
require_once('fpdi/src/autoload.php');

use setasign\Fpdi\Fpdi;

include("../conexion.php");

if (!isset($_GET["id"])) {
    die("ID de usuario no proporcionado.");
}
$id = intval($_GET["id"]);

$resCedula = $conexion->query("SELECT * FROM usuario_cedula WHERE id_usuario = $id");
$cedula = $resCedula->fetch_assoc();
if (!$cedula) {
    die("Datos de cédula no encontrados.");
}

$pdf = new Fpdi();
$pdf->AddPage();
$pdf->SetFont('Helvetica', '', 12);

// Detectar tipo de imagen manualmente (solo JPEG o PNG)
function detectar_extension($imagen_binaria) {
    if (strpos($imagen_binaria, "\xFF\xD8") === 0) {
        return '.jpg';
    } elseif (strpos($imagen_binaria, "\x89PNG") === 0) {
        return '.png';
    } else {
        return false;
    }
}

// Imagen frontal
if (!empty($cedula['imagen_frontal'])) {
    $ext_frontal = detectar_extension($cedula['imagen_frontal']);
    if (!$ext_frontal) die("Imagen frontal no válida");

    $tempFrontal = tempnam(sys_get_temp_dir(), 'frontal_') . $ext_frontal;
    file_put_contents($tempFrontal, $cedula['imagen_frontal']);
    $pdf->Image($tempFrontal, 30, 25, 70);
    unlink($tempFrontal);
} else {
    $pdf->Cell(0, 10, 'No se encontró imagen frontal.', 0, 1);
}

// Imagen reverso
if (!empty($cedula['imagen_reverso'])) {
    $ext_reverso = detectar_extension($cedula['imagen_reverso']);
    if (!$ext_reverso) die("Imagen reverso no válida");

    $tempReverso = tempnam(sys_get_temp_dir(), 'reverso_') . $ext_reverso;
    file_put_contents($tempReverso, $cedula['imagen_reverso']);
    $pdf->Image($tempReverso, 110, 25, 70);
    unlink($tempReverso);
} else {
    $pdf->Cell(0, 10, 'No se encontró imagen reverso.', 0, 1);
}

ob_clean();
header("Content-Type: application/pdf");
header("Content-Disposition: inline; filename=formulario_$id.pdf");
$pdf->Output();
exit;
