document.addEventListener("DOMContentLoaded", () => {
  verificarSesion()
    .then((data) => {
      if (data) {
        if (data.rol === "superadmin") {
          const btn = document.querySelector(".btn-agregar-admin");
          if (btn) btn.style.display = "inline-block";
        } else {
          const btn = document.querySelector(".btn-agregar-admin");
          if (btn) btn.style.display = "none";
        }

        cargarUsuarios();
      } else {
        window.location.href = "https://muniloncochedigital.cl/tto/";
      }
    })
    .catch(() => {
      window.location.href = "https://muniloncochedigital.cl/tto/";
    });
});


async function verificarSesion() {
  try {
    const res = await fetch("include/auth_check.php", {
      credentials: "include",
    });

    if (!res.ok) return null;

    const data = await res.json();
    return data;
  } catch (error) {
    console.log("Error en verificarSesion:", error);
    return null;
  }
}


let usuarios = [];

function cargarUsuarios() {
  fetch("include/cargar_usuarios.php")
    .then((res) => res.json())
    .then((data) => {
      usuarios = data;
      mostrarUsuarios(usuarios);
    })
    .catch((error) => {
      console.error("Error al cargar usuarios:", error);
      alert("Error al cargar usuarios.");
    });
}
const registrosPorPagina = 25;
let paginaActual = 1;

function mostrarUsuarios(lista) {
  const tbody = document.querySelector("#tablaUsuarios tbody");
  tbody.innerHTML = "";

  const totalPaginas = Math.ceil(lista.length / registrosPorPagina);
  const inicio = (paginaActual - 1) * registrosPorPagina;
  const fin = inicio + registrosPorPagina;
  const paginaUsuarios = lista.slice(inicio, fin);

  paginaUsuarios.forEach((u) => {
    const fila = document.createElement("tr");
    fila.innerHTML = `
      <td>${u.nombre}</td>
      <td>${u.run}</td>
      <td>${formatearFecha(u.fecha_registro)}</td>
      <td>${crearBotonSaludPDF(u.tiene_salud, `generar_declaracion.php?id=${u.id_usuario}`)}</td>
      <td>${crearBotonPDF(u.tiene_salud, `generar_pdf.php?id=${u.id_usuario}`)}</td>
      <td>
        <div style="display: flex; justify-content: center;">
          <a href="cedula_pdf.php?id=${u.id_usuario}" target="_blank" class="btn btn-outline-success btn-sm">
            <i class="bi bi-file-earmark-break-fill"></i> Cédula
          </a>
        </div>
      </td>
    `;
    tbody.appendChild(fila);
  });

  renderizarPaginacion(totalPaginas);
}
function renderizarPaginacion(totalPaginas) {
  const paginacion = document.getElementById("paginacion");
  paginacion.className = "pagination-container text-center mt-3";
  paginacion.innerHTML = "";

  if (totalPaginas <= 1) return;

  const crearBtn = (texto, pagina, clase = "") => {
    const btn = document.createElement("button");
    btn.innerHTML = texto;
    btn.className = `btn btn-sm mx-1 ${clase}`;
    btn.onclick = () => {
      if (pagina >= 1 && pagina <= totalPaginas) {
        paginaActual = pagina;
        mostrarUsuarios(usuarios);
      }
    };
    return btn;
  };

  if (paginaActual > 1) {
    paginacion.appendChild(crearBtn("&laquo;", paginaActual - 1, "btn-outline-secondary"));
  }

  let start = Math.max(1, paginaActual - 1);
  let end = Math.min(totalPaginas, start + 4);

  if (end - start < 4) {
    start = Math.max(1, end - 4);
  }

  for (let i = start; i <= end; i++) {
    const clase = i === paginaActual ? "btn-primary" : "btn-outline-secondary";
    paginacion.appendChild(crearBtn(i, i, clase));
  }

  if (paginaActual < totalPaginas) {
    paginacion.appendChild(crearBtn("&raquo;", paginaActual + 1, "btn-outline-secondary"));
  }
}


function crearBotonPDF(tieneDato, urlPDF) {
  if (parseInt(tieneDato) > 0) {
    return `
      <div style="display: flex; justify-content: center;">
        <a href="${urlPDF}" target="_blank" class="btn btn-outline-danger btn-sm btn-pdf">
          <i class="bi bi-file-earmark-text-fill"></i> PDF
        </a>
      </div>`;
  } else {
    return `<div style="text-align: center;">—</div>`;
  }
}

function crearBotonSaludPDF(tieneDato, urlPDF) {
  if (parseInt(tieneDato) > 0) {
    return `
      <div style="display: flex; justify-content: center;">
        <a href="${urlPDF}" target="_blank" class="btn btn-outline-danger btn-sm btn-pdf">
          <i class="bi bi-file-earmark-medical-fill"></i> PDF
        </a>
      </div>`;
  } else {
    return `<div style="text-align: center;">—</div>`;
  }
}

function filtrarUsuarios(termino) {
  const normalizado = termino.trim().toLowerCase();
  const filtrados = usuarios.filter(u =>
    u.nombre.toLowerCase().includes(normalizado) ||
    u.run.toLowerCase().includes(normalizado)
  );
  mostrarUsuarios(filtrados);
}
function agregaradmin() {
  window.location.href = "../admin/agregar/agregar_admin.html";
}
function buscar() {
  const input = document.querySelector('input[type="text"]');
  if (input) {
    filtrarUsuarios(input.value);
  }
}

function limpiar() {
  const input = document.querySelector('input[type="text"]');
  if (input) {
    input.value = "";
    mostrarUsuarios(usuarios); 
  }
}
function formatearFecha(fechaCompleta) {
  const fecha = new Date(fechaCompleta);
  if (isNaN(fecha)) return fechaCompleta;
  return fecha.toLocaleDateString('es-CL');
}
function crearBotonCedula(tieneCedula, urlCedula) {
  if (parseInt(tieneCedula) > 0) {
    return `
      <div style="display: flex; justify-content: center;">
        <a href="${urlCedula}" target="_blank" class="btn btn-outline-success btn-sm">
          <i class="bi bi-card-image"></i> Cédula
        </a>
      </div>`;
  } else {
    return `<div style="text-align: center;">—</div>`;
  }
}
