<?php
require_once('fpdf/fpdf.php');
require_once('fpdi/src/autoload.php');
use setasign\Fpdi\Fpdi;

include("../conexion.php");

if (!isset($_GET['id'])) {
    die("ID de usuario no especificado.");
}
$id = intval($_GET['id']);

// Consultar datos del usuario
$resUsuario = $conexion->query("SELECT * FROM usuario WHERE id_usuario = $id");
$u = $resUsuario->fetch_assoc();
if (!$u){
    die("Usuario no encontrado.");
}

$pdf = new Fpdi();
$pdf->setSourceFile('formulario-nuevo2.pdf');

// Página base
$template1 = $pdf->importPage(1);
$size = $pdf->getTemplateSize($template1);
$pdf->AddPage($size['orientation'], [$size['width'], $size['height']]);
$pdf->useTemplate($template1);
$pdf->SetFont('Helvetica', '', 11);

// Consultar datos de drogas
$resDrogas = $conexion->query("SELECT * FROM usuario_drogas WHERE id_usuario = $id");
$drogas = $resDrogas->fetch_assoc();
if (!$drogas){
    die("Datos de Drogas no encontrados.");
}

// Consultar datos de residencia
$resResidencia = $conexion->query("SELECT * FROM usuario_residencia WHERE id_usuario = $id");
$residencia = $resResidencia->fetch_assoc();
if (!$residencia){
    die("Datos de Residencia no encontrados.");
}

// Nombre
$pdf->SetXY(62, 29);
$pdf->Write(8, utf8_decode($drogas["nombre"]));

// RUT
$pdf->SetXY(62, 37);
$pdf->Write(8, utf8_decode($drogas["rut"]));

// Dirección
$pdf->SetXY(62, 45);
$pdf->Write(8, utf8_decode($drogas["direccion"]));

// Ciudad
$pdf->SetXY(62, 53);
$pdf->Write(8, utf8_decode($drogas["ciudad"]));

// Firma (si existe)
if (!empty($u["firma"])) {
    $imageData = $u["firma"];
    $tempFile = tempnam(sys_get_temp_dir(), 'firma_') . '.png';
    file_put_contents($tempFile, $imageData);

    if (!getimagesize($tempFile)) {
        unlink($tempFile);
        die("Firma inválida.");
    }

    $pdf->Image($tempFile, 142, 197, 44, 24);
    unlink($tempFile);
}

// Fecha
$pdf->SetXY(44, 231);
$fechaCompleta = $u["fecha_registro"];
$soloFecha = date('d-m-Y', strtotime($fechaCompleta));
$pdf->Write(11, $soloFecha);

ob_clean();
header("Content-Type: application/pdf");
header("Content-Disposition: inline; filename=declaracion_$id.pdf");
$pdf->Output();
exit;
?>
