<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

ob_start();

require_once('fpdf/fpdf.php');
require_once('fpdi/src/autoload.php');

use setasign\Fpdi\Fpdi;

include("../conexion.php");

//Obtener usuario
if (!isset($_GET["id"])) {
    echo "ID de usuario no proporcionado";
    exit;
}
$id = intval($_GET["id"]);
$res = $conexion->query("SELECT * FROM usuario WHERE id_usuario = $id");
$u = $res->fetch_assoc();
if (!$u) {
    echo "Usuario no encontrado";
    exit;
}

// Consultar datos de licencia
$resLicencia = $conexion->query("SELECT * FROM licencia WHERE id_usuario = $id");
$lic = $resLicencia->fetch_assoc();
if (!$lic){
    echo "Licencia no encontrado";
    exit;
}
// Consultar datos de laboral
$resLaboral = $conexion->query("SELECT * FROM laboral WHERE id_usuario = $id");
$laboral = $resLaboral->fetch_assoc();
if (!$laboral){
    echo "Datos laborales no encontrados";
    exit;
}

// Consultar datos de salud
$resSalud = $conexion->query("SELECT * FROM salud WHERE id_usuario = $id");
$sal = $resSalud->fetch_assoc();
if (!$sal){
    echo "Salud no encontrada";
    exit;
}

// Consultar datos de hábitos
$resHabitos = $conexion->query("SELECT * FROM habitos WHERE id_usuario = $id");
$hab = $resHabitos->fetch_assoc();
if (!$hab){
    echo "Hábitos no encontrados";
    exit;
}
function ajustarTexto($pdf, $texto, $x, $y, $maxWidth, $fontSizeBase = 11, $fontName = 'Helvetica', $minFontSize = 7) {
    $pdf->SetFont($fontName, '', $fontSizeBase);
    $texto = utf8_decode($texto);

    $width = $pdf->GetStringWidth($texto);

    if ($width > $maxWidth) {
        $nuevoTamaño = max($minFontSize, $fontSizeBase * ($maxWidth / $width));
        $pdf->SetFont($fontName, '', $nuevoTamaño);
    }

    $pdf->SetXY($x, $y);
    $pdf->Write(8, $texto);
    $pdf->SetFont($fontName, '', $fontSizeBase);
}



// Crear FPDI
$pdf = new FPDI();
// Importar la plantilla PDF
$pdf->setSourceFile('formulario-nuevo.pdf');

// Importar primera página
$template1 = $pdf->importPage(1);
$size = $pdf->getTemplateSize($template1);
$pdf->AddPage($size['orientation'], [$size['width'], $size['height']]);
$pdf->useTemplate($template1);
$pdf->SetFont('Helvetica', '', 11);

ajustarTexto($pdf, $u["nombre"], 39, 113, 70); 

$pdf->SetXY(132, 112); 
$pdf->Write(8, utf8_decode($u["run"]));


// Firma
if (!empty($u["firma"])) {
    $imageData = $u["firma"]; 

    $tempFile = tempnam(sys_get_temp_dir(), 'firma_') . '.png';
    file_put_contents($tempFile, $imageData);

    if (!getimagesize($tempFile)) {
        unlink($tempFile);
        throw new Exception("La firma guardada no es una imagen válida");
    }

    $pdf->Image($tempFile, 91, 142, 35, 15); // X, Y, Ancho, Alto

    unlink($tempFile);
}


//Fecha
$pdf->SetXY(150, 169);
$fechaCompleta = $u["fecha_registro"];
$soloFecha = date('d-m-Y', strtotime($fechaCompleta));
$pdf->Write(8, $soloFecha);


//Campos de datos personales
//Nombre
ajustarTexto($pdf, $u["nombre"], 32, 195, 101); 

//Edad
$pdf->SetXY(146, 189); 
$pdf->Write(8, utf8_decode($u["edad"]));

//Sexo
$pdf->SetXY(166, 188); 
$pdf->Write(8, utf8_decode($u["sexo"]));

//Peso
$pdf->SetXY(142, 201); 
$pdf->Write(8, utf8_decode($u["peso"]));

//Estatura
$pdf->SetXY(172, 197); 
$pdf->Write(8, utf8_decode($u["estatura"]));

// Campos de datos de licencia conductor
function marcarX($pdf, $x, $y) {
    $pdf->SetFont('Helvetica', 'B', 12); 
    $pdf->SetXY($x, $y);
    $pdf->Cell(5, 5, 'X', 0, 0, 'C'); 
}

$posee = strtolower(trim($lic["posee_licencia"]));

if ($posee == "si" || $posee == "sí") {

    // PROFESIONAL
    $profesional = strtoupper(trim($lic["profesional"]));
    $coordenadas_profesional = [
        "A-1" => [72, 212],
        "A-2" => [72, 217],
        "A-3" => [72, 221],
        "A-4" => [72, 225],
        "A-5" => [72, 230],
    ];
    if (!empty($profesional)) {
        $profesional_array = explode(",", $profesional);
        foreach ($profesional_array as $p) {
            $p = strtoupper(trim($p));
            if (isset($coordenadas_profesional[$p])) {
                list($x, $y) = $coordenadas_profesional[$p];
                marcarX($pdf, $x, $y);
            }
        }
    }

    // NO PROFESIONAL
    $no_profesional = strtoupper(trim($lic["no_profesional"]));
    $coordenadas_no_profesional = [
        "B" => [101, 212],
        "C" => [101, 217],
    ];
    if (!empty($no_profesional)) {
        $no_profesional_array = explode(",", $no_profesional);
        foreach ($no_profesional_array as $np) {
            $np = strtoupper(trim($np));
            if (isset($coordenadas_no_profesional[$np])) {
                list($x, $y) = $coordenadas_no_profesional[$np];
                marcarX($pdf, $x, $y);
            }
        }
    }

    // ESPECIALES 
    $especiales = strtoupper(trim($lic["especiales"]));
    $coordenadas_especiales = [
        "D" => [131, 212],
        "E" => [131, 217],
        "F" => [131, 221],
    ];
    if (!empty($especiales)) {
        $especiales_array = explode(",", $especiales);
        foreach ($especiales_array as $esp) {
            $esp = strtoupper(trim($esp));
            if (isset($coordenadas_especiales[$esp])) {
                list($x, $y) = $coordenadas_especiales[$esp];
                marcarX($pdf, $x, $y);
            }
        }
    }

    // ANTES FECHA
    $antes_fecha = strtoupper(trim($lic["antes_fecha"]));
    $coordenadas_antes_fecha = [
        "A-1" => [165, 220],
        "A-2" => [165, 225],
    ];
    if (!empty($antes_fecha)) {
        $antes_fecha_array = explode(",", $antes_fecha);
        foreach ($antes_fecha_array as $af) {
            $af = strtoupper(trim($af));
            if (isset($coordenadas_antes_fecha[$af])) {
                list($x, $y) = $coordenadas_antes_fecha[$af];
                marcarX($pdf, $x, $y);
            }
        }
    }

} elseif ($posee == "no") {
    // NO posee licencia
    marcarX($pdf, 33, 247);
}

// === Campos de Estudios ===
$estudios = strtoupper(trim($laboral["estudios"])); 
$coordenadas_estudios = [
    "E. BASICA INCOMPLETA" => [82, 264],
    "E. BASICA COMPLETA" => [124, 264],
    "E. MEDIA" => [148, 264],
    "E. SUPERIOR" => [178, 264],
];
if (!empty($estudios) && isset($coordenadas_estudios[$estudios])) {
    list($x, $y) = $coordenadas_estudios[$estudios];
    marcarX($pdf, $x, $y);
}

// === Campos de Situación Laboral ===
$situacion = strtoupper(trim($laboral["situacion"])); 
$coordenadas_situacion = [
    "ACTIVO(A)" => [82, 275],
    "ESTUDIANTE" => [81.5, 284],
    "DESEMPLEADO(A)" => [128, 275],
    "LABORES DE CASA" => [128, 284],
    "JUBILADO(A)" => [170.5, 275],
    "PENSIONADO(A)" => [174.5, 284],
];
if (!empty($situacion) && isset($coordenadas_situacion[$situacion])) {
    list($x, $y) = $coordenadas_situacion[$situacion];
    marcarX($pdf, $x, $y);
}

$pdf->SetFont('Helvetica', '', 11);
// Campos de Oficio
ajustarTexto($pdf, $laboral["oficio"], 35, 295, 180); 

//Campos de Jornada
$jornada = strtoupper(trim($laboral["jornada"])); 
$coordenadas_jornada = [
    "DIURNA" => [70.5, 304],
    "TURNO" => [98, 304],
];
if (!empty($jornada) && isset($coordenadas_jornada[$jornada])) {
    list($x, $y) = $coordenadas_jornada[$jornada];
    marcarX($pdf, $x, $y);
}
//Campos de  Horario
$horario = strtoupper(trim($laboral["horario"])); 
$coordenadas_horario = [
    "FIJO" => [135, 304],
    "ROTATIVO" => [159, 304],
];
if (!empty($horario) && isset($coordenadas_horario[$horario])) {
    list($x, $y) = $coordenadas_horario[$horario];
    marcarX($pdf, $x, $y);
}

// Segunda página
$template2 = $pdf->importPage(2);
$size2 = $pdf->getTemplateSize($template2);

$pdf->AddPage($size2['orientation'], [$size2['width'], $size2['height']]);
$pdf->useTemplate($template2);

//Campos de valvula cardiaca
$valvula = strtoupper(trim($sal["valvula_cardiaca"])); 
$coordenadas_valvula = [
    "SI" => [145, 48],
    "NO" => [164.5, 48],
];
if (!empty($valvula) && isset($coordenadas_valvula[$valvula])) {
    list($x, $y) = $coordenadas_valvula[$valvula];
    marcarX($pdf, $x, $y);
}
//Campos de bypass- coronario
$bypass = strtoupper(trim($sal["bypass_coronario"])); 
$coordenadas_bypass = [
    "SI" => [145, 58],
    "NO" => [164.5, 58],
];
if (!empty($bypass) && isset($coordenadas_bypass[$bypass])) {
    list($x, $y) = $coordenadas_bypass[$bypass];
    marcarX($pdf, $x, $y);
}


// Campos de implante marcapasos
$marcapasos = strtoupper(trim($sal["implante_marcapasos"])); 
$coordenadas_marcapasos = [
    "SI" => [145, 67],
    "NO" => [164.5, 67],
];
if (!empty($marcapasos) && isset($coordenadas_marcapasos[$marcapasos])) {
    list($x, $y) = $coordenadas_marcapasos[$marcapasos];
    marcarX($pdf, $x, $y);
}

//CATARATAS
$raw_cataratas = strtoupper(trim($sal["cataratas"]));
$partes = explode("-", $raw_cataratas);

$cataratas = trim($partes[0]);
$ojo_cataratas = isset($partes[1]) ? trim($partes[1]) : null; 

$coordenadas_cataratas = [
    "SI" => [145, 77],
    "NO" => [164.5, 77],
];
if (!empty($cataratas) && isset($coordenadas_cataratas[$cataratas])) {
    list($x, $y) = $coordenadas_cataratas[$cataratas];
    marcarX($pdf, $x, $y);
}

if ($cataratas === "SI" && !empty($ojo_cataratas)) {
    $pdf->SetFont('Arial', '', 9);
    $pdf->SetXY(187, 77); 
    $pdf->Cell(60, 5, $ojo_cataratas, 0, 1);
}

// Campos de glaucoma
$raw_glaucoma = strtoupper(trim($sal["glaucoma"]));
$partes_glaucoma = explode("-", $raw_glaucoma);

$glaucoma = trim($partes_glaucoma[0]);
$ojo_glaucoma = isset($partes_glaucoma[1]) ? trim($partes_glaucoma[1]) : null;

$coordenadas_glaucoma = [
    "SI" => [145, 86],
    "NO" => [164.5, 86],
];
if (!empty($glaucoma) && isset($coordenadas_glaucoma[$glaucoma])) {
    list($x, $y) = $coordenadas_glaucoma[$glaucoma];
    marcarX($pdf, $x, $y);
}
if ($glaucoma === "SI" && !empty($ojo_glaucoma)) {
    $pdf->SetFont('Arial', '', 9);
    $pdf->SetXY(187, 86);
    $pdf->Cell(60, 5, $ojo_glaucoma, 0, 1);
}
// Campos de enfermedad retina
$raw_retina = strtoupper(trim($sal["enfermedad_retina"]));
$partes_retina = explode("-", $raw_retina);

$retina = trim($partes_retina[0]);
$ojo_retina = isset($partes_retina[1]) ? trim($partes_retina[1]) : null;

$coordenadas_retina = [
    "SI" => [145, 95],
    "NO" => [164.5, 95],
];
if (!empty($retina) && isset($coordenadas_retina[$retina])) {
    list($x, $y) = $coordenadas_retina[$retina];
    marcarX($pdf, $x, $y);
}
if ($retina === "SI" && !empty($ojo_retina)) {
    $pdf->SetFont('Arial', '', 9);
    $pdf->SetXY(187, 95);
    $pdf->Cell(60, 5, $ojo_retina, 0, 1);
}

// Campos de operación ojos
$ojos = strtoupper(trim($sal["operacion_ojos"])); 
$coordenadas_ojos = [
    "SI" => [145, 104],
    "NO" => [164.5, 104],
];
if (!empty($ojos) && isset($coordenadas_ojos[$ojos])) {
    list($x, $y) = $coordenadas_ojos[$ojos];
    marcarX($pdf, $x, $y);
}

// Campos de lentes cerca
$lentes_cerca = strtoupper(trim($sal["usa_lentes_cerca"])); 
$coordenadas_lentes_cerca = [
    "SI" => [145, 113],
    "NO" => [164.5, 113],
];
if (!empty($lentes_cerca) && isset($coordenadas_lentes_cerca[$lentes_cerca])) {
    list($x, $y) = $coordenadas_lentes_cerca[$lentes_cerca];
    marcarX($pdf, $x, $y);
}

// Campos de lentes lejos
$lentes_lejos = strtoupper(trim($sal["usa_lentes_lejos"])); 
$coordenadas_lentes_lejos = [
    "SI" => [145, 123],
    "NO" => [164.5, 123],
];
if (!empty($lentes_lejos) && isset($coordenadas_lentes_lejos[$lentes_lejos])) {
    list($x, $y) = $coordenadas_lentes_lejos[$lentes_lejos];
    marcarX($pdf, $x, $y);
}

// Campos de enfermedad de oídos
$oidos = strtoupper(trim($sal["enfermedad_oidos"])); 
$coordenadas_oidos = [
    "SI" => [145, 132],
    "NO" => [164.5, 132],
];
if (!empty($oidos) && isset($coordenadas_oidos[$oidos])) {
    list($x, $y) = $coordenadas_oidos[$oidos];
    marcarX($pdf, $x, $y);
}

// Campos de mareos o vértigo
$mareos = strtoupper(trim($sal["mareos_vertigo"])); 
$coordenadas_mareos = [
    "SI" => [145, 141],
    "NO" => [164.5, 141],
];
if (!empty($mareos) && isset($coordenadas_mareos[$mareos])) {
    list($x, $y) = $coordenadas_mareos[$mareos];
    marcarX($pdf, $x, $y);
}

// Campos de uso de audífonos
$audifonos = strtoupper(trim($sal["usa_audifonos"])); 
$coordenadas_audifonos = [
    "SI" => [145, 150],
    "NO" => [164.5, 150],
];
if (!empty($audifonos) && isset($coordenadas_audifonos[$audifonos])) {
    list($x, $y) = $coordenadas_audifonos[$audifonos];
    marcarX($pdf, $x, $y);
}

// Campos de desmayo o pérdida de conciencia
$desmayo = strtoupper(trim($sal["desmayo_conciencia"])); 
$coordenadas_desmayo = [
    "SI" => [145, 159],
    "NO" => [164.5, 159],
];
if (!empty($desmayo) && isset($coordenadas_desmayo[$desmayo])) {
    list($x, $y) = $coordenadas_desmayo[$desmayo];
    marcarX($pdf, $x, $y);
}

// Campos de epilepsia o convulsiones
$epilepsia = strtoupper(trim($sal["epilepsia_convulsiones"])); 
$coordenadas_epilepsia = [
    "SI" => [145, 168],
    "NO" => [164.5, 168],
];
if (!empty($epilepsia) && isset($coordenadas_epilepsia[$epilepsia])) {
    list($x, $y) = $coordenadas_epilepsia[$epilepsia];
    marcarX($pdf, $x, $y);
}

// Campos de pérdida de fuerza
$perdida_fuerza = strtoupper(trim($sal["perdida_fuerza"])); 
$coordenadas_perdida_fuerza = [
    "SI" => [145, 177],
    "NO" => [164.5, 177],
];
if (!empty($perdida_fuerza) && isset($coordenadas_perdida_fuerza[$perdida_fuerza])) {
    list($x, $y) = $coordenadas_perdida_fuerza[$perdida_fuerza];
    marcarX($pdf, $x, $y);
}

// Campos de esclerosis múltiple
$esclerosis = strtoupper(trim($sal["esclerosis_multiple"])); 
$coordenadas_esclerosis = [
    "SI" => [145, 186],
    "NO" => [164.5, 186],
];
if (!empty($esclerosis) && isset($coordenadas_esclerosis[$esclerosis])) {
    list($x, $y) = $coordenadas_esclerosis[$esclerosis];
    marcarX($pdf, $x, $y);
}

// Campos de parkinson
$parkinson = strtoupper(trim($sal["parkinson"])); 
$coordenadas_parkinson = [
    "SI" => [145, 195],
    "NO" => [164.5, 195],
];
if (!empty($parkinson) && isset($coordenadas_parkinson[$parkinson])) {
    list($x, $y) = $coordenadas_parkinson[$parkinson];
    marcarX($pdf, $x, $y);
}

// Campos de T.E.C. (traumatismo encéfalo craneano)
$tec = strtoupper(trim($sal["tec"])); 
$coordenadas_tec = [
    "SI" => [145, 204],
    "NO" => [164.5, 204],
];
if (!empty($tec) && isset($coordenadas_tec[$tec])) {
    list($x, $y) = $coordenadas_tec[$tec];
    marcarX($pdf, $x, $y);
}

// Campos de pérdida de extremidad
$perdida_extremidad = strtoupper(trim($sal["perdida_extremidad"])); 
$coordenadas_perdida_extremidad = [
    "SI" => [145, 214],
    "NO" => [164.5, 214],
];
if (!empty($perdida_extremidad) && isset($coordenadas_perdida_extremidad[$perdida_extremidad])) {
    list($x, $y) = $coordenadas_perdida_extremidad[$perdida_extremidad];
    marcarX($pdf, $x, $y);
}

// Campos de dificultad para hablar o escribir
$dificultad_hablar = strtoupper(trim($sal["dificultad_hablar_escribir"])); 
$coordenadas_dificultad_hablar = [
    "SI" => [145, 225],
    "NO" => [164.5, 225],
];
if (!empty($dificultad_hablar) && isset($coordenadas_dificultad_hablar[$dificultad_hablar])) {
    list($x, $y) = $coordenadas_dificultad_hablar[$dificultad_hablar];
    marcarX($pdf, $x, $y);
}

// Campos de hipertensión
$hipertension = strtoupper(trim($sal["hipertension"])); 
$coordenadas_hipertension = [
    "SI" => [145, 234],
    "NO" => [164.5, 234],
];
if (!empty($hipertension) && isset($coordenadas_hipertension[$hipertension])) {
    list($x, $y) = $coordenadas_hipertension[$hipertension];
    marcarX($pdf, $x, $y);
}

// Campos de cansancio diurno
$cansancio = strtoupper(trim($sal["cansancio_diurno"])); 
$coordenadas_cansancio = [
    "SI" => [145, 243],
    "NO" => [164.5, 243],
];
if (!empty($cansancio) && isset($coordenadas_cansancio[$cansancio])) {
    list($x, $y) = $coordenadas_cansancio[$cansancio];
    marcarX($pdf, $x, $y);
}

// Campos de diabetes
$diabetes = strtoupper(trim($sal["diabetes"])); 
$coordenadas_diabetes = [
    "SI" => [145, 255],
    "NO" => [164.5, 255],
];
if (!empty($diabetes) && isset($coordenadas_diabetes[$diabetes])) {
    list($x, $y) = $coordenadas_diabetes[$diabetes];
    marcarX($pdf, $x, $y);
}

// Campos de dificultad para respirar
$dificultad_respirar = strtoupper(trim($sal["dificultad_respirar"])); 
$coordenadas_dificultad_respirar = [
    "SI" => [145, 264],
    "NO" => [164.5, 264],
];
if (!empty($dificultad_respirar) && isset($coordenadas_dificultad_respirar[$dificultad_respirar])) {
    list($x, $y) = $coordenadas_dificultad_respirar[$dificultad_respirar];
    marcarX($pdf, $x, $y);
}

// Campos de palpitaciones
$palpitaciones = strtoupper(trim($sal["palpitaciones"])); 
$coordenadas_palpitaciones = [
    "SI" => [145, 273],
    "NO" => [164.5, 273],
];
if (!empty($palpitaciones) && isset($coordenadas_palpitaciones[$palpitaciones])) {
    list($x, $y) = $coordenadas_palpitaciones[$palpitaciones];
    marcarX($pdf, $x, $y);
}

// Campos de dolor de pecho con esfuerzo
$dolor_pecho = strtoupper(trim($sal["dolor_pecho_esfuerzo"])); 
$coordenadas_dolor_pecho = [
    "SI" => [145, 282],
    "NO" => [164.5, 282],
];
if (!empty($dolor_pecho) && isset($coordenadas_dolor_pecho[$dolor_pecho])) {
    list($x, $y) = $coordenadas_dolor_pecho[$dolor_pecho];
    marcarX($pdf, $x, $y);
}

// Campos de enfermedad renal
$enfermedad_renal = strtoupper(trim($sal["enfermedad_renal"])); 
$coordenadas_enfermedad_renal = [
    "SI" => [145, 291],
    "NO" => [164.5, 291],
];
if (!empty($enfermedad_renal) && isset($coordenadas_enfermedad_renal[$enfermedad_renal])) {
    list($x, $y) = $coordenadas_enfermedad_renal[$enfermedad_renal];
    marcarX($pdf, $x, $y);
}

// Campos de olvidos frecuentes
$olvidos = strtoupper(trim($sal["olvidos_frecuentes"])); 
$coordenadas_olvidos = [
    "SI" => [145, 301],
    "NO" => [164.5, 301],
];
if (!empty($olvidos) && isset($coordenadas_olvidos[$olvidos])) {
    list($x, $y) = $coordenadas_olvidos[$olvidos];
    marcarX($pdf, $x, $y);
}

// Campos de problemas psicológicos
$psicologicos = strtoupper(trim($sal["problemas_psicologicos"])); 
$coordenadas_psicologicos = [
    "SI" => [145, 310],
    "NO" => [164.5, 310],
];
if (!empty($psicologicos) && isset($coordenadas_psicologicos[$psicologicos])) {
    list($x, $y) = $coordenadas_psicologicos[$psicologicos];
    marcarX($pdf, $x, $y);
}

// Campos de trastornos psiquiátricos
$psiquiatricos = strtoupper(trim($sal["trastornos_psiquiatricos"])); 
$coordenadas_psiquiatricos = [
    "SI" => [145, 319],
    "NO" => [164.5, 319],
];
if (!empty($psiquiatricos) && isset($coordenadas_psiquiatricos[$psiquiatricos])) {
    list($x, $y) = $coordenadas_psiquiatricos[$psiquiatricos];
    marcarX($pdf, $x, $y);
}

// Tercera página
$template3 = $pdf->importPage(3);
$size3 = $pdf->getTemplateSize($template3);

$pdf->AddPage($size3['orientation'], [$size3['width'], $size3['height']]);
$pdf->useTemplate($template3);

// Campos de cáncer
$raw_cancer = strtoupper(trim($sal["cancer"]));
$partes_cancer = explode("-", $raw_cancer);

$cancer = trim($partes_cancer[0]);
$tipo_cancer = isset($partes_cancer[1]) ? trim($partes_cancer[1]) : null;

$coordenadas_cancer = [
    "SI" => [138, 33],
    "NO" => [157, 33],
];

if (!empty($cancer) && isset($coordenadas_cancer[$cancer])) {
    list($x, $y) = $coordenadas_cancer[$cancer];
    marcarX($pdf, $x, $y);
}

if ($cancer === "SI" && !empty($tipo_cancer)) {
    $pdf->SetFont('Helvetica', '', 9);
    $pdf->SetXY(173, 34);
    $pdf->Cell(70, 5, $tipo_cancer, 0, 1);
}

// Campos de enfermedad de hígado
$higado = strtoupper(trim($sal["enfermedad_higado"])); 
$coordenadas_higado = [
    "SI" => [145, 43],
    "NO" => [164.5, 43],
];
if (!empty($higado) && isset($coordenadas_higado[$higado])) {
    list($x, $y) = $coordenadas_higado[$higado];
    marcarX($pdf, $x, $y);
}

// Campos de accidente cerebrovascular (ACV)
$acv = strtoupper(trim($sal["acv"])); 
$coordenadas_acv = [
    "SI" => [145, 52],
    "NO" => [164.5, 52],
];
if (!empty($acv) && isset($coordenadas_acv[$acv])) {
    list($x, $y) = $coordenadas_acv[$acv];
    marcarX($pdf, $x, $y);
}

// Campos de problemas para dormir
$problemas_dormir = strtoupper(trim($sal["problemas_dormir"])); 
$coordenadas_problemas_dormir = [
    "SI" => [145, 61],
    "NO" => [164.5, 61],
];
if (!empty($problemas_dormir) && isset($coordenadas_problemas_dormir[$problemas_dormir])) {
    list($x, $y) = $coordenadas_problemas_dormir[$problemas_dormir];
    marcarX($pdf, $x, $y);
}

// Campos de ronquidos
$ronquidos = strtoupper(trim($sal["ronquidos"])); 
$coordenadas_ronquidos = [
    "SI" => [145, 70],
    "NO" => [164.5, 70],
];
if (!empty($ronquidos) && isset($coordenadas_ronquidos[$ronquidos])) {
    list($x, $y) = $coordenadas_ronquidos[$ronquidos];
    marcarX($pdf, $x, $y);
}

// Campos de apneas del sueño
$apneas = strtoupper(trim($sal["apneas_sueno"])); 
$coordenadas_apneas = [
    "SI" => [145, 82],
    "NO" => [164.5, 82],
];
if (!empty($apneas) && isset($coordenadas_apneas[$apneas])) {
    list($x, $y) = $coordenadas_apneas[$apneas];
    marcarX($pdf, $x, $y);
}
// Campos de enfermedades del corazón
$enfermedades_corazon = trim($sal["enfermedades_corazon"]);

if (!empty($enfermedades_corazon)) {
    $items = preg_split('/\s*,\s*/', $enfermedades_corazon);

    $coordenadas_y = [
        "INSUFICIENCIA CARDIACA" => 91,
        "INFARTOS" => 100,
        "ANGINAS DE PECHO" => 109,
        "ARRITMIAS" => 118,
    ];

    foreach ($items as $item) {
        $partes = explode(":", $item);
        if (count($partes) === 2) {
            $nombre = mb_strtoupper(trim($partes[0]));
            $respuesta = mb_strtoupper(trim($partes[1]));

            if (isset($coordenadas_y[$nombre])) {
                $y = $coordenadas_y[$nombre];

                if ($nombre === "ARRITMIAS") {
                    $x = $respuesta === "SI" ? 138 : 157;
                } else {
                    $x = $respuesta === "SI" ? 145 : 164.5;
                }

                marcarX($pdf, $x, $y);
            }
        }
    }
}

// Campos de operado
$raw_operado = strtoupper(trim($sal["operado"]));
$partes_operado = explode("-", $raw_operado);

$operado = trim($partes_operado[0]); 
$tipo_operado = isset($partes_operado[1]) ? trim($partes_operado[1]) : null;

$coordenadas_operado = [
    "SI" => [88, 127],
    "NO" => [107, 127], 
];

if (!empty($operado) && isset($coordenadas_operado[$operado])) {
    list($x, $y) = $coordenadas_operado[$operado];
    marcarX($pdf, $x, $y);
}

if ($operado === "SI" && !empty($tipo_operado)) {
    $pdf->SetFont('Helvetica', '', 9);
    $pdf->SetXY(148, 127);
    $pdf->Cell(70, 5, $tipo_operado, 0, 1);
}


// Campos de otra_enfermedad
$raw_otra_enfermedad = strtoupper(trim($sal["otra_enfermedad"]));
$partes_otra_enfermedad = explode("-", $raw_otra_enfermedad);

$otra_enfermedad = trim($partes_otra_enfermedad[0]);
$detalle_otra_enfermedad = isset($partes_otra_enfermedad[1]) ? trim($partes_otra_enfermedad[1]) : null;

$coordenadas_otra_enfermedad = [
    "SI" => [88, 137],
    "NO" => [107, 137],
];

if (!empty($otra_enfermedad) && isset($coordenadas_otra_enfermedad[$otra_enfermedad])) {
    list($x, $y) = $coordenadas_otra_enfermedad[$otra_enfermedad];
    marcarX($pdf, $x, $y);
}

if ($otra_enfermedad === "SI" && !empty($detalle_otra_enfermedad)) {
    $pdf->SetFont('Helvetica', '', 9);
    $pdf->SetXY(132, 140);
    $pdf->Cell(70, 5, $detalle_otra_enfermedad, 0, 1);
}


// Campos de licencia_mas
$raw_licencia_mas = strtoupper(trim($sal["licencia_mas"]));
$partes_licencia_mas = explode("-", $raw_licencia_mas);

$licencia_mas = trim($partes_licencia_mas[0]);
$detalle_licencia_mas = isset($partes_licencia_mas[1]) ? trim($partes_licencia_mas[1]) : null;

$coordenadas_licencia_mas = [
    "SI" => [87, 159],
    "NO" => [106, 159], 
];

if (!empty($licencia_mas) && isset($coordenadas_licencia_mas[$licencia_mas])) {
    list($x, $y) = $coordenadas_licencia_mas[$licencia_mas];
    marcarX($pdf, $x, $y);
}

if ($licencia_mas === "SI" && !empty($detalle_licencia_mas)) {
    $pdf->SetFont('Helvetica', '', 9);
    $pdf->SetXY(132, 167); 
    $pdf->Cell(70, 5, $detalle_licencia_mas, 0, 1);
}


// Campos de uso de medicamento
$uso_medicamento = strtoupper(trim($sal["uso_medicamento"])); 
$coordenadas_uso_medicamento = [
    "SI" => [151, 176],
    "NO" => [170, 176],
];
if (!empty($uso_medicamento) && isset($coordenadas_uso_medicamento[$uso_medicamento])) {
    list($x, $y) = $coordenadas_uso_medicamento[$uso_medicamento];
    marcarX($pdf, $x, $y);
}

// Medicamento, cantidad y motivo
if (strtoupper(trim($sal["uso_medicamento"])) === "SI") {
    $medicamentos = array_map('trim', explode(",", $sal["medicamento"]));
    $cantidades   = array_map('trim', explode(",", $sal["cantidad"]));
    $motivos      = array_map('trim', explode(",", $sal["motivo"]));

    $pdf->SetFont('Helvetica', '', 11);
    $pdf->SetXY(33, 194);

    $y = 194;  
    $x = 33;  

    $total_items = min(22, max(count($medicamentos), count($cantidades), count($motivos)));

    for ($i = 0; $i < $total_items; $i++) {
        $med = isset($medicamentos[$i]) ? $medicamentos[$i] : '';
        $cant = isset($cantidades[$i]) ? $cantidades[$i] : '';
        $mot = isset($motivos[$i]) ? $motivos[$i] : '';
    
        // Medicamento
        ajustarTexto($pdf, $med, 30, $y, 52);
    
        // Cantidad
        $pdf->SetXY(83, $y);
        $pdf->MultiCell(50, 5, $cant);
    
        // Motivo
        ajustarTexto($pdf, $mot, 132, $y, 100);

    
        // Incrementar la posición vertical
        $y += 7;
    }    
}

// Cuarta página
$template4 = $pdf->importPage(4);
$size4 = $pdf->getTemplateSize($template4);

$pdf->AddPage($size4['orientation'], [$size4['width'], $size4['height']]);
$pdf->useTemplate($template4);

// === Campos de conduce ===
$conduce = strtoupper(trim(utf8_encode($hab["conduce"])));
$coordenadas_conduce = [
    "TODOS LOS DIAS" => [95, 47],
    "ALGUNOS DIAS DE LA SEMANA" => [153, 47],
    "ALGUNOS DIAS AL MES" => [96, 55], 
    "ALGUNOS DIAS AL ANO" => [155, 55],
];
if (!empty($conduce) && isset($coordenadas_conduce[$conduce])) {
    list($x, $y) = $coordenadas_conduce[$conduce];
    marcarX($pdf, $x, $y);
}
// Campos de utiliza_trabajo
$trabajo = strtoupper(trim($hab["utiliza_trabajo"])); 
$coordenadas_trabajo = [
    "SI" => [128, 67],
    "NO" => [159, 67],
];
if (!empty($trabajo) && isset($coordenadas_trabajo[$trabajo])) {
    list($x, $y) = $coordenadas_trabajo[$trabajo];
    marcarX($pdf, $x, $y);
}
// Campos de evaluacion_medica
$medica = strtoupper(trim($hab["evaluacion_medica"])); 
$coordenadas_evaluacion = [
    "SI" => [128, 79],
    "NO" => [159, 79],
];
if (!empty($coordenadas_evaluacion) && isset($coordenadas_evaluacion[$trabajo])) {
    list($x, $y) = $coordenadas_evaluacion[$medica];
    marcarX($pdf, $x, $y);
}

// === Campos de Conduce algun lugar ===
$lugar = strtoupper(trim($hab["conduce_lugar"])); 
$coordenadas_lugar = [
    "CIUDAD" => [101, 91],
    "CARRETERA" => [140, 91],
    "AMBAS" => [166, 91],
];
if (!empty($lugar) && isset($coordenadas_lugar[$lugar])) {
    list($x, $y) = $coordenadas_lugar[$lugar];
    marcarX($pdf, $x, $y);
}
// Campos de accidente
$accidente = strtoupper(trim($hab["accidente"])); 
$coordenadas_accidente = [
    "SI" => [127, 103],
    "NO" => [159, 103],
];
if (!empty($coordenadas_accidente) && isset($coordenadas_accidente[$accidente])) {
    list($x, $y) = $coordenadas_accidente[$accidente];
    marcarX($pdf, $x, $y);
}
$pdf->SetFont('Helvetica', '', 11);

//Campos de tenido accidente
$pdf->SetXY(30, 122); 
$pdf->Write(8, utf8_decode($hab["tenido_accidente"]));

// Firma
if (!empty($u["firma"])) {
    $imageData = $u["firma"]; 

    $tempFile = tempnam(sys_get_temp_dir(), 'firma_') . '.png';
    file_put_contents($tempFile, $imageData);

    if (!getimagesize($tempFile)) {
        unlink($tempFile);
        throw new Exception("La firma guardada no es una imagen válida");
    }

    $pdf->Image($tempFile, 86, 149, 50, 25); // X, Y, Ancho, Alto

    unlink($tempFile);
}
//Campos de RUN
$pdf->SetXY(100, 172); 
$pdf->Write(8, utf8_decode($u["run"]));

ob_clean();
header("Content-Type: application/pdf");
header("Content-Disposition: inline; filename=formulario_$id.pdf");
$pdf->Output();
exit;
?>
