<?php
session_start();
include("../../conexion.php");
header('Content-Type: application/json');

if (!isset($_SESSION['usuario']) || !isset($_SESSION['rol'])) {
    http_response_code(401);
    echo json_encode(["error" => "No autenticado"]);
    exit;
}

if (!isset($conexion) || $conexion->connect_error) {
    http_response_code(500);
    echo json_encode(["error" => "Error de conexión", "detalle" => $conexion->connect_error]);
    exit;
}

$sql = "
SELECT 
    u.id_usuario, 
    u.nombre, 
    u.run, 
    u.fecha_registro,
    (CASE WHEN (u.edad IS NOT NULL AND u.peso IS NOT NULL AND u.sexo IS NOT NULL) THEN 1 ELSE 0 END) AS tiene_salud,
    (SELECT COUNT(*) FROM usuario_drogas d WHERE d.id_usuario = u.id_usuario) AS tiene_drogas,
    (SELECT COUNT(*) FROM usuario_residencia r WHERE r.id_usuario = u.id_usuario) AS tiene_residencia
FROM usuario u
ORDER BY u.fecha_registro DESC";

$result = $conexion->query($sql);

if ($result) {
    $usuarios = [];
    while ($row = $result->fetch_assoc()) {
        $row['tiene_salud'] = (int)$row['tiene_salud'];
        $row['tiene_drogas'] = (int)$row['tiene_drogas'] > 0 ? 1 : 0;
        $row['tiene_residencia'] = (int)$row['tiene_residencia'] > 0 ? 1 : 0;

        if (
            ($row['tiene_salud'] || $row['tiene_drogas'] || $row['tiene_residencia']) &&
            !empty($row['nombre']) &&
            !empty($row['run'])
        ) {
            $usuarios[] = $row;
        }
    }
    echo json_encode($usuarios);
} else {
    http_response_code(500);
    echo json_encode(["error" => "Error en la consulta", "detalle" => $conexion->error]);
}

$conexion->close();
