<?php
include("conexion.php");
session_start();

function getPost($campo) {
    return trim(htmlspecialchars($_POST[$campo] ?? ''));
}
function procesarBase64($base64) {
    if (!preg_match('/^data:image\/(png|jpeg);base64,/', $base64)) {
        throw new Exception("La imagen debe estar en formato PNG o JPEG.");
    }
    $partes = explode(',', $base64);
    return base64_decode(end($partes));
}

$conexion->begin_transaction();

try {
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
    $firmaBin = $_POST['firmaImg']; 
    if (!preg_match('/^data:image\/(png|jpeg);base64,/', $firmaBin)) {
        throw new Exception("La imagen debe estar en formato PNG o JPEG.");
    }
    $partes = explode(',', $firmaBin);
    $firma = base64_decode(end($partes)); 
    // === 1. USUARIO ===
    $nombre = getPost('nombre'); 
    $run       = strtoupper(getPost('run'));
    $edad      = intval(getPost('edad'));
    $peso      = floatval(getPost('peso'));
    $sexo      = getPost('sexo');
    $estatura  = floatval(getPost('estatura'));
    $fecha     = date("Y-m-d H:i:s");
    $acuerdo = getPost('acuerdo_declaracion_salud');

    $stmt = $conexion->prepare("INSERT INTO usuario (nombre, run, edad, peso, sexo, estatura, firma, fecha_registro, acuerdo)
                                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssidsdsss", $nombre, $run, $edad, $peso, $sexo, $estatura, $firma, $fecha, $acuerdo);
    $stmt->execute();
    $id_usuario = $stmt->insert_id;
    $stmt->close();

    // === 2. LICENCIA ===
    $posee_licencia = getPost('posee_licencia');
    $profesional    = getPost('profesional');
    $no_profesional = getPost('no_profesional');
    $especiales     = getPost('especiales');
    $antes_fecha    = getPost('antes_fecha');

    $stmt = $conexion->prepare("INSERT INTO licencia (id_usuario, posee_licencia, profesional, no_profesional, especiales, antes_fecha)
                                 VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("isssss", $id_usuario, $posee_licencia, $profesional, $no_profesional, $especiales, $antes_fecha);
    $stmt->execute();
    $stmt->close();

    // === 3. LABORAL ===
    $estudios   = getPost('estudios');
    $situacion  = getPost('situacion');
    $oficio     = getPost('oficio');
    $jornada    = getPost('jornada');
    $horario    = getPost('horario');

    $stmt = $conexion->prepare("INSERT INTO laboral (id_usuario, estudios, situacion, oficio, jornada, horario)
                                 VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("isssss", $id_usuario, $estudios, $situacion, $oficio, $jornada, $horario);
    $stmt->execute();
    $stmt->close();

    // === 4. SALUD ===
    $campos_salud = [
        'valvula_cardiaca', 'bypass_coronario', 'implante_marcapasos', 'cataratas', 'glaucoma', 'enfermedad_retina',
        'operacion_ojos', 'usa_lentes_cerca', 'usa_lentes_lejos', 'enfermedad_oidos', 'mareos_vertigo', 'usa_audifonos',
        'desmayo_conciencia', 'epilepsia_convulsiones', 'perdida_fuerza', 'esclerosis_multiple', 'parkinson', 'tec',
        'perdida_extremidad', 'dificultad_hablar_escribir', 'hipertension', 'diabetes', 'cansancio_diurno', 'dificultad_respirar',
        'palpitaciones', 'dolor_pecho_esfuerzo', 'enfermedad_renal', 'olvidos_frecuentes', 'problemas_psicologicos',
        'trastornos_psiquiatricos', 'cancer', 'enfermedad_higado', 'acv', 'problemas_dormir', 'ronquidos', 'apneas_sueno',
        'enfermedades_corazon', 'operado', 'otra_enfermedad', 'licencia_mas', 'uso_medicamento', 'medicamento', 'cantidad', 'motivo'
    ];
    $valores_salud = [];
    foreach ($campos_salud as $campo) {
        $valores_salud[] = getPost($campo);
    }

    $sql_salud = "INSERT INTO salud (id_usuario, " . implode(", ", $campos_salud) . ")
                  VALUES (?" . str_repeat(", ?", count($campos_salud)) . ")";
    $stmt = $conexion->prepare($sql_salud);

    $types = "s" . str_repeat("s", count($campos_salud));
    $stmt->bind_param($types, $id_usuario, ...$valores_salud);
    $stmt->execute();
    $stmt->close();

    // === 5. HÁBITOS ===
    $conduce            = getPost('conduce');
    $utiliza_trabajo    = getPost('utiliza_trabajo');
    $evaluacion_medica  = getPost('evaluacion_medica');
    $conduce_lugar      = getPost('conduce_lugar');
    $accidente          = getPost('accidente');
    $tenido_accidente   = getPost('tenido_accidente');
    if ($accidente === 'No') {
        $tenido_accidente = 'No Aplica';
    }

    $stmt = $conexion->prepare("INSERT INTO habitos (id_usuario, conduce, utiliza_trabajo, evaluacion_medica, conduce_lugar, accidente, tenido_accidente)
                                 VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("issssss", $id_usuario, $conduce, $utiliza_trabajo, $evaluacion_medica, $conduce_lugar, $accidente, $tenido_accidente);
    $stmt->execute();
    $stmt->close();

    // === 6. DROGAS ===
    $nombre_drogas  = getPost('nombre_drogas');
    $rut_drogas     = getPost('rut_drogas');
    $direccion      = getPost('direccion');
    $ciudad         = getPost('ciudad');
    $acuerdo_drogas = getPost('acuerdo_declaracion_drogas');

    $stmt = $conexion->prepare("INSERT INTO usuario_drogas (id_usuario, nombre, rut, direccion, ciudad, firma, fecha_registro, acuerdo)
                                VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("isssssss", $id_usuario, $nombre_drogas, $rut_drogas, $direccion, $ciudad, $firma, $fecha, $acuerdo_drogas);
    $stmt->execute();
    $stmt->close();

    // === 7. RESIDENCIA ===
    $nombre_residencia  = getPost('nombre_residencia');
    $rut_residencia     = getPost('rut_residencia');
    $direccion_residencia = getPost('direccion_residencia');
    $ciudad_residencia = getPost('ciudad_residencia');
    $acuerdo_residencia = getPost('acuerdo_declaracion_residencia');

    // Captura de carnet
    $foto_frente = $_POST['foto_frente'] ?? null;
    $foto_reverso = $_POST['foto_reverso'] ?? null;

    if (!$foto_frente || !$foto_reverso) {
        throw new Exception("Debe capturar ambas imágenes del carnet antes de guardar.");
    }

    $imgFrente = procesarBase64($foto_frente);
    $imgReverso = procesarBase64($foto_reverso);

    $stmt = $conexion->prepare("INSERT INTO usuario_residencia (
        id_usuario, nombre, rut, direccion, ciudad, firma, fecha_registro, acuerdo
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("isssssss", $id_usuario, $nombre_residencia, $rut_residencia, $direccion_residencia, $ciudad_residencia, $firma, $fecha, $acuerdo_residencia);
    $stmt->execute();
    $stmt->close();

    // === 8. USUARIO_CEDULA ===
    $stmt = $conexion->prepare("INSERT INTO usuario_cedula (id_usuario, imagen_frontal, imagen_reverso) VALUES (?, ?, ?)");
    $stmt->bind_param("iss", $id_usuario, $imgFrente, $imgReverso);
    $stmt->execute();
    $stmt->close();

    $conexion->commit();
    echo "Todos los datos han sido guardados correctamente.";

} catch (Exception $e) {
    $conexion->rollback();
    http_response_code(500);
    die("ERROR GUARDAR: " . $e->getMessage());
}
?>
