let alertaNombreMostrada = false;
let alertaRutMostrada = false;

function limpiarFormatoRut(rut) {
  return rut.replace(/\./g, '').toUpperCase();
}

function validarRut(value) {
  value = limpiarFormatoRut(value);
  if (!/^\d{7,8}-[0-9K]$/.test(value)) {
    throw new Error('El RUT debe ingresarse sin puntos y con guion (ej: 12345678-K).');
  }

  const [rutBase, digitoVerificador] = value.split('-');
  let suma = 0, multiplicador = 2;
  for (let i = rutBase.length - 1; i >= 0; i--) {
    suma += parseInt(rutBase[i]) * multiplicador;
    multiplicador = (multiplicador === 7) ? 2 : multiplicador + 1;
  }

  let dvCalculado = 11 - (suma % 11);
  dvCalculado = dvCalculado === 11 ? '0' : dvCalculado === 10 ? 'K' : dvCalculado.toString();
  if (digitoVerificador !== dvCalculado) {
    throw new Error('El RUT no es válido.');
  }
}

function formatearNombre(texto) {
  return texto.toLowerCase().replace(/(^|\s)[a-záéíóúüñ]/g, l => l.toUpperCase()).trim().replace(/\s+/g, ' ');
}

function nombreValido(texto) {
  return /^[A-Za-zÁÉÍÓÚÜÑáéíóúüñ'\-\s]{3,60}$/.test(texto);
}

function mostrarInputCondicional(idDiv, idInput, mostrar, limpiarTexto = false) {
  const div = document.getElementById(idDiv);
  const input = document.getElementById(idInput);
  if (mostrar) {
    div.style.display = 'flex';
    input.value = "";
    if (limpiarTexto) document.getElementById(limpiarTexto).value = "";
  } else {
    div.style.display = 'none';
    input.value = "No";
    if (limpiarTexto) document.getElementById(limpiarTexto).value = "";
  }
}

function actualizarCampo(idCampo, valor) {
  document.getElementById(idCampo).value = valor;
}

function agregarFila() {
  const tabla = document.getElementById('tablaMedicamentos').getElementsByTagName('tbody')[0];
  const nuevaFila = tabla.rows[0].cloneNode(true);
  const inputs = nuevaFila.getElementsByTagName('input');
  for (let input of inputs) input.value = "";

  const celdaAccion = nuevaFila.insertCell(-1);
  const btnEliminar = document.createElement('button');
  btnEliminar.type = 'button';
  btnEliminar.textContent = '-';
  btnEliminar.className = 'btn btn-danger btn-sm';
  btnEliminar.onclick = () => eliminarFila(btnEliminar);
  celdaAccion.appendChild(btnEliminar);

  tabla.appendChild(nuevaFila);
}

function eliminarFila(boton) {
  const fila = boton.closest('tr');
  const tabla = document.getElementById('tablaMedicamentos').getElementsByTagName('tbody')[0];
  if (tabla.rows.length > 1) {
    fila.remove();
  } else {
    alert('Debe haber al menos una fila de medicamento.');
  }
}

function validarCamposStep(stepId) {
  const step = document.getElementById(`step${stepId}`);
  const requiredElements = step.querySelectorAll('[required]');
  const checkedRadios = new Set();
  const erroresMostrados = new Set();

  for (let el of requiredElements) {
    if (el.offsetParent === null || el.disabled) continue;

    if (el.type === 'radio') {
      if (checkedRadios.has(el.name)) continue;
      checkedRadios.add(el.name);

      const radios = step.querySelectorAll(`input[name="${el.name}"]`);
      const algunoMarcado = Array.from(radios).some(r => r.checked);
      if (!algunoMarcado) {
        if (!erroresMostrados.has(el.name)) {
          alert(`Debe seleccionar una opción para: ${el.name}`);
          erroresMostrados.add(el.name);
        }
        radios[0].focus();
        return false;
      }

    } else {
      if (!el.value.trim() && !erroresMostrados.has(el.name)) {
        alert(`Por favor complete el campo: ${el.name || el.id}`);
        erroresMostrados.add(el.name);
        el.focus();
        return false;
      }
    }
  }

  return true;
}

function validarTodoAntesDeGuardar() {
  for (let paso = 1; paso <= 9; paso++) {
    const step = document.getElementById(`step${paso}`);
    step.classList.add('active');
    if (!validarCamposStep(paso)) {
      nextStep(paso);
      return false;
    }
    step.classList.remove('active');
  }

  sincronizarCamposLicencia();
  juntarMedicamentos();

  const frente = document.getElementById('foto_frente').value;
  const reverso = document.getElementById('foto_reverso').value;

  if (!frente || !reverso) {
    let mensaje = "Debes capturar ";
    if (!frente && !reverso) {
      mensaje += "el anverso y reverso del carnet antes de guardar.";
    } else if (!frente) {
      mensaje += "el anverso del carnet antes de guardar.";
    } else {
      mensaje += "el reverso del carnet antes de guardar.";
    }

    alert(mensaje);
    nextStep(8);
    return;
  }

  if (!signaturePad || signaturePad.isEmpty()) {
    alert("Debe firmar antes de guardar.");
    nextStep(9);
    return false;
  }

document.getElementById('firmaImg').value = signaturePad.toDataURL('image/png');
  return true;
}

function nextStepValidado(actual, siguiente) {
  if (!validarCamposStep(actual)) {
    return false;
  }

  const tabs = document.querySelectorAll('.tab-pane');
  const navLinks = document.querySelectorAll('#stepTabs .nav-link');
  tabs.forEach(tab => tab.classList.remove('show', 'active'));
  navLinks.forEach(link => link.classList.remove('active'));

  document.getElementById(`step${siguiente}`).classList.add('show', 'active');
  navLinks[siguiente - 1].classList.add('active');

  if (siguiente === 8) setTimeout(resizeFirmaCanvas, 200);

  return true;
}


function toggleLicencia(tieneLicencia) {
  const bloque = document.getElementById('bloqueLicencia');
  bloque.style.display = tieneLicencia ? 'block' : 'none';
  if (!tieneLicencia) {
    document.querySelectorAll('#bloqueLicencia input[type=radio]').forEach(el => el.checked = false);
  }
}

function limpiarFirma() {
  if (signaturePad) {
    signaturePad.clear();
    document.getElementById('firmaImg').value = '';
  }
}

function validarCamposStep(stepId) {
  const step = document.getElementById(`step${stepId}`);
  const requiredElements = step.querySelectorAll('[required]');
  const checkedRadios = new Set();
  const erroresMostrados = new Set();

  for (let el of requiredElements) {
    if (el.offsetParent === null || el.disabled) continue;

    if (el.type === 'radio') {
      if (checkedRadios.has(el.name)) continue;
      checkedRadios.add(el.name);
      const radios = step.querySelectorAll(`input[name="${el.name}"]`);
      const algunoMarcado = Array.from(radios).some(r => r.checked);

      if (!algunoMarcado) {
        if (!erroresMostrados.has(el.name)) {
          alert(`Debe seleccionar una opción para: ${el.name}`);
          erroresMostrados.add(el.name);
        }
        radios[0].focus();
        return false;
      }
    } else {
      if (!el.value.trim() && !erroresMostrados.has(el.name)) {
        alert(`Por favor complete el campo: ${el.name || el.id}`);
        erroresMostrados.add(el.name);
        el.focus();
        return false;
      }
    }
  }

  return true;
}

function nextStep(numero) {
  const tabs = document.querySelectorAll('.tab-pane');
  const navLinks = document.querySelectorAll('#stepTabs .nav-link');

  tabs.forEach(tab => tab.classList.remove('show', 'active'));
  navLinks.forEach(link => link.classList.remove('active'));

  const currentTab = document.getElementById(`step${numero}`);
  const currentLink = navLinks[numero - 1];

  currentTab.classList.add('show', 'active');
  currentLink.classList.add('active');
  
}

function validarLicencia() {
  const tieneLicencia = document.querySelector('input[name="posee_licencia"]:checked')?.value === 'Si';

  if (tieneLicencia) {
    const categorias = ['profesional', 'no_profesional', 'especiales', 'antes_fecha'];
    let seleccionValida = false;

    for (const nombre of categorias) {
      const opciones = document.getElementsByName(nombre);
      if ([...opciones].some(op => op.checked)) {
        seleccionValida = true;
        break;
      }
    }

    if (!seleccionValida) {
      alert("Debe seleccionar al menos una subcategoría de licencia si indicó que posee una.");
      return false;
    }
  }

  return true;
}

function mostrarCondicional(idContenedor, idCampo, mostrar, limpiarTexto = false) {
  const div = document.getElementById(idContenedor);
  const input = document.getElementById(idCampo);

  if (!div || !input) return;

  if (mostrar) {
    div.style.display = 'flex';
    input.value = "";
    if (limpiarTexto) {
      const campoTexto = document.getElementById(limpiarTexto);
      if (campoTexto) campoTexto.value = '';
    }
  } else {
    div.style.display = 'none';
    input.value = "No";
    if (limpiarTexto) {
      const campoTexto = document.getElementById(limpiarTexto);
      if (campoTexto) campoTexto.value = '';
    }
  }
}
function mostrarInputCancer(mostrar) {
  const inputDiv = document.getElementById('inputTipoCancer');
  const inputHidden = document.getElementById('cancer');
  const textoCancer = document.getElementById('textoCancer');
  inputDiv.style.display = mostrar ? 'flex' : 'none';
  inputHidden.value = mostrar ? (textoCancer.value ? "Si - " + textoCancer.value : "Si") : "No";
}

function mostrarOpcionesCataratas(mostrar) {
  const opciones = document.getElementById('opcionesCataratas');
  const inputHidden = document.getElementById('cataratas');

  if (mostrar) {
    opciones.style.display = 'flex';
    inputHidden.value = "Si";
  } else {
    opciones.style.display = 'none';
    inputHidden.value = "No"; 
    const ojos = document.getElementsByName('cataratas_ojo');
    ojos.forEach((o) => { o.checked = false; });
  }
}
function actualizarCataratas(ojo) {
  const inputHidden = document.getElementById('cataratas');
  inputHidden.value = "Si - " + ojo;
}

function mostrarOpcionesGlaucoma(mostrar) {
  const opciones = document.getElementById('opcionesGlaucoma');
  const inputHidden = document.getElementById('glaucoma');

  if (mostrar) {
    opciones.style.display = 'flex';
    inputHidden.value = "Si";
  } else {
    opciones.style.display = 'none';
    inputHidden.value = "No";
    const ojos = document.getElementsByName('glaucoma_ojo');
    ojos.forEach((o) => { o.checked = false; });
  }
}
function actualizarGlaucoma(ojo) {
  const inputHidden = document.getElementById('glaucoma');
  inputHidden.value = "Si - " + ojo;
}

function mostrarOpcionesRetina(mostrar) {
  const opciones = document.getElementById('opcionesRetina');
  const inputHidden = document.getElementById('enfermedad_retina');

  if (mostrar) {
    opciones.style.display = 'flex';
    inputHidden.value = "Si"; 
  } else {
    opciones.style.display = 'none';
    inputHidden.value = "No";
    const ojos = document.getElementsByName('enfermedad_retina_ojo');
    ojos.forEach((o) => { o.checked = false; });
  }
}

function actualizarRetina(ojo) {
  const inputHidden = document.getElementById('enfermedad_retina');
  inputHidden.value = "Si - " + ojo;
}
function mostrarInputOperado(mostrar) {
  const inputDiv = document.getElementById('inputOperado');
  const inputHidden = document.getElementById('operado');
  const texto = document.getElementById('textoOperado');
  inputDiv.style.display = mostrar ? 'flex' : 'none';
  inputHidden.value = mostrar ? (texto.value ? "Si - " + texto.value : "Si") : "No";
}
function mostrarInputEnfermedad(mostrar) {
  const inputDiv = document.getElementById('inputOtraEnfermedad');
  const inputHidden = document.getElementById('otra_enfermedad');
  const texto = document.getElementById('textoOtraEnfermedad');
  inputDiv.style.display = mostrar ? 'flex' : 'none';
  inputHidden.value = mostrar ? (texto.value ? "Si - " + texto.value : "Si") : "No";
}
function mostrarInputLicencia(mostrar) {
  const inputDiv = document.getElementById('inputLicenciaMas');
  const inputHidden = document.getElementById('licencia_mas');
  const texto = document.getElementById('textoLicenciaMas');
  inputDiv.style.display = mostrar ? 'flex' : 'none';
  inputHidden.value = mostrar ? (texto.value ? "Si - " + texto.value : "Si") : "No";
}
function mostrarInputAccidente(mostrar) {
  const inputDivAccidente = document.getElementById('inputAccidente');
  const inputHiddenAccidente = document.getElementById('accidente');
  const textoAccidente = document.getElementById('textoAccidente');

  if (mostrar) {
    inputDivAccidente.style.display = 'flex';
    inputHiddenAccidente.value = "Si"; 
    textoAccidente.value = "";
  } else {
    inputDivAccidente.style.display = 'none';
    textoAccidente.value = "No aplica"; 
    inputHiddenAccidente.value = "No";
  }
}

function validarFormularioAccidente(event) {
  const accidenteSi = document.getElementById('accidenteSi').checked;
  const textoAccidente = document.getElementById('textoAccidente').value.trim();
  const inputHiddenAccidente = document.getElementById('accidente');

  if (accidenteSi) {
    if (textoAccidente === "") {
      document.getElementById('textoAccidente').value = "No aplica";
    }
    inputHiddenAccidente.value = "Si";
  } else {
    inputHiddenAccidente.value = "No";
    document.getElementById('textoAccidente').value = "No aplica";
  }
}
function mostrarTablaMedicamentos(mostrar) {
  const container = document.getElementById('tablaMedicamentosContainer');
  const medicamento = document.getElementById('medicamento');
  const cantidad = document.getElementById('cantidad');
  const motivo = document.getElementById('motivo');

  if (mostrar) {
    container.style.display = 'block';
    medicamento.value = "";
    cantidad.value = "";
    motivo.value = "";
  } else {
    container.style.display = 'none';
    medicamento.value = "No";
    cantidad.value = "No";
    motivo.value = "No";
  }
}
function toggleAccidente(mostrar) {
  const detalle = document.getElementById('detalleAccidente');
  detalle.style.display = mostrar ? 'block' : 'none';
}

function prevStep(numero) {
  const tabs = document.querySelectorAll('.tab-pane');
  const navLinks = document.querySelectorAll('#stepTabs .nav-link');

  tabs.forEach(tab => tab.classList.remove('show', 'active'));
  navLinks.forEach(link => link.classList.remove('active'));

  const currentTab = document.getElementById(`step${numero}`);
  const currentLink = navLinks[numero - 1];

  currentTab.classList.add('show', 'active');
  currentLink.classList.add('active');

  if (numero === 8) {
  }
}

let alertaNombreDrogasMostrada = false;
let alertaNombreResidenciaMostrada = false;
let alertaRutDrogasMostrada = false;
let alertaRutResidenciaMostrada = false;

document.addEventListener('DOMContentLoaded', () => {
  const nombres = [
    { id: 'nombre_drogas', alerta: () => alertaNombreDrogasMostrada, setAlerta: v => alertaNombreDrogasMostrada = v },
    { id: 'nombre_residencia', alerta: () => alertaNombreResidenciaMostrada, setAlerta: v => alertaNombreResidenciaMostrada = v }
  ];

  const ruts = [
    { id: 'rut_drogas', alerta: () => alertaRutDrogasMostrada, setAlerta: v => alertaRutDrogasMostrada = v },
    { id: 'rut_residencia', alerta: () => alertaRutResidenciaMostrada, setAlerta: v => alertaRutResidenciaMostrada = v }
  ];

  nombres.forEach(({ id, alerta, setAlerta }) => {
    const input = document.getElementById(id);
    if (!input) return;

    input.addEventListener('input', () => {
      input.value = input.value.replace(/[^A-Za-zÁÉÍÓÚÜÑáéíóúüñ'\-\s]/g, '');
    });

    input.addEventListener('blur', () => {
      input.value = formatearNombre(input.value);
      if (!nombreValido(input.value)) {
        input.classList.remove('is-valid');
        input.classList.add('is-invalid');
        if (!alerta()) {
          alert(`El nombre ingresado en "${id}" no es válido.`);
          setAlerta(true);
        }
        input.focus();
      } else {
        input.classList.remove('is-invalid');
        input.classList.add('is-valid');
        setAlerta(false);
      }
    });
  });

  ruts.forEach(({ id, alerta, setAlerta }) => {
    const input = document.getElementById(id);
    if (!input) return;

    input.addEventListener('blur', () => {
      try {
        const limpio = limpiarFormatoRut(input.value.trim());
        validarRut(limpio);
        input.value = limpio;
        input.classList.remove('is-invalid');
        input.classList.add('is-valid');
        setAlerta(false);
      } catch (error) {
        input.classList.remove('is-valid');
        input.classList.add('is-invalid');
        if (!alerta()) {
          alert(`RUT en "${id}" no válido: ${error.message}`);
          setAlerta(true);
        }
        input.focus();
        input.select();
      }
    });
  });
});

document.addEventListener('DOMContentLoaded', () => {
  const canvas = document.getElementById('firma');
  const firmaImg = document.getElementById('firmaImg');

  function ajustarCanvas() {
    const rect = canvas.getBoundingClientRect();
    const ratio = window.devicePixelRatio || 1;
    canvas.width = rect.width * ratio;
    canvas.height = rect.height * ratio;
    const ctx = canvas.getContext('2d');
    ctx.setTransform(1, 0, 0, 1, 0, 0);
    ctx.scale(ratio, ratio);
  }

  ajustarCanvas();
  window.addEventListener('resize', ajustarCanvas);

  signaturePad = new SignaturePad(canvas, {
    penColor: 'black',
    backgroundColor: 'white'
  });

  canvas.addEventListener('mouseup', () => {
    if (!signaturePad.isEmpty()) {
      firmaImg.value = signaturePad.toDataURL('image/png');
    }
  });

  canvas.addEventListener('touchend', () => {
    if (!signaturePad.isEmpty()) {
      firmaImg.value = signaturePad.toDataURL('image/png');
    }
  });
});
function sincronizarCamposLicencia() {
  const grupos = ['profesional', 'no_profesional', 'especiales', 'antes_fecha'];

  grupos.forEach(grupo => {
    const seleccionados = Array.from(document.querySelectorAll(`input[name="${grupo}"]:not([type="hidden"]):checked`))
      .map(input => input.value);

    const hidden = document.querySelector(`input[type="hidden"][name="${grupo}"]`);
    if (hidden) {
      hidden.value = seleccionados.length > 0 ? seleccionados.join(', ') : "No";
    }
  });
}

document.addEventListener('DOMContentLoaded', function () {
  const formulario = document.querySelector('form');
  if (formulario) {
    formulario.addEventListener('submit', validarTodo);
    
    inicializarValores();
    inicializarEventListeners();
    
    document.querySelectorAll('#tablaMedicamentos tbody tr:first-child input').forEach(input => {
      input.addEventListener('input', juntarMedicamentos);
    });
  }
  
  const radios = document.querySelectorAll('input[type="radio"]');
  radios.forEach(radio => {
    radio.addEventListener('change', function() {
      if (this.name === 'cancer_radio') mostrarInputCancer(this.value === 'Si');
      if (this.name === 'operado_radio') mostrarInputOperado(this.value === 'Si');
      if (this.name === 'otra_enfermedad_radio') mostrarInputEnfermedad(this.value === 'Si');
      if (this.name === 'licencia_mas_radio') mostrarInputLicencia(this.value === 'Si');
      if (this.name === 'uso_medicamento') mostrarTablaMedicamentos(this.value === 'Si');
      
      const corazonRadios = ['insuficiencia_cardiaca', 'infartos', 'anginas_pecho', 'arritmias'];
      if (corazonRadios.includes(this.name)) {
        juntarEnfermedades();
      }
    });
  });
});
function validarTodo(event) {
  const cancerSi = document.getElementById('cancerSi').checked;
  const textoCancer = document.getElementById('textoCancer').value.trim();
  const inputHiddenCancer = document.getElementById('cancer');
  if (cancerSi && textoCancer === "") {
    alert('Por favor, especifique el tipo de cáncer.');
    event.preventDefault(); return false;
  }
  if (cancerSi) inputHiddenCancer.value = "Si - " + textoCancer;

  const operadoSi = document.getElementById('operadoSi').checked;
  const textoOperado = document.getElementById('textoOperado').value.trim();
  const inputHiddenOperado = document.getElementById('operado');
  if (operadoSi && textoOperado === "") {
    alert('Por favor, especifique el tipo de operación.');
    event.preventDefault(); return false;
  }
  if (operadoSi) inputHiddenOperado.value = "Si - " + textoOperado;

  const otraSi = document.getElementById('otraEnfermedadSi').checked;
  const textoOtra = document.getElementById('textoOtraEnfermedad').value.trim();
  const inputOtra = document.getElementById('otra_enfermedad');
  if (otraSi && textoOtra === "") {
    alert('Por favor, especifique el tipo de enfermedad.');
    event.preventDefault(); return false;
  }
  if (otraSi) inputOtra.value = "Si - " + textoOtra;

  const licenciaSi = document.getElementById('licenciaMasSi').checked;
  const textoLic = document.getElementById('textoLicenciaMas').value.trim();
  const inputLic = document.getElementById('licencia_mas');
  if (licenciaSi && textoLic === "") {
    alert('Por favor, especifique el motivo de licencia.');
    event.preventDefault(); return false;
  }
  if (licenciaSi) inputLic.value = "Si - " + textoLic;

  const usoMedicamento = document.querySelector('input[name="uso_medicamento"]:checked');
  if (usoMedicamento && usoMedicamento.value === 'Si') {
    const medicamentosArray = document.getElementsByName('medicamento_array[]');
    const cantidadesArray = document.getElementsByName('cantidad_array[]');
    const motivosArray = document.getElementsByName('motivo_array[]');
    
    let algunoCompleto = false;
    for (let i = 0; i < medicamentosArray.length; i++) {
      if (medicamentosArray[i].value.trim() !== '') {
        algunoCompleto = true;
        if (cantidadesArray[i].value.trim() === '') {
          alert('Por favor complete la cantidad diaria para el medicamento ' + medicamentosArray[i].value);
          event.preventDefault(); return false;
        }
        if (motivosArray[i].value.trim() === '') {
          alert('Por favor complete el motivo para el medicamento ' + medicamentosArray[i].value);
          event.preventDefault(); return false;
        }
      }
    }
    
    if (!algunoCompleto) {
      alert('Por favor, añada al menos un medicamento o seleccione "No" en la pregunta.');
      event.preventDefault(); return false;
    }
  }

  juntarEnfermedades();
  juntarMedicamentos();

  return true;
}

function juntarMedicamentos() {
  const medicamentos = [];
  const cantidades = [];
  const motivos = [];

  document.querySelectorAll('input[name="medicamento_array[]"]').forEach(input => {
    medicamentos.push(input.value.trim());
  });

  document.querySelectorAll('input[name="cantidad_array[]"]').forEach(input => {
    cantidades.push(input.value.trim());
  });

  document.querySelectorAll('input[name="motivo_array[]"]').forEach(input => {
    motivos.push(input.value.trim());
  });

  document.getElementById('medicamento').value = medicamentos.join(', ');
  document.getElementById('cantidad').value = cantidades.join(', ');
  document.getElementById('motivo').value = motivos.join(', ');
}

function inicializarValores() {
  document.getElementById('cancer').value = "No";
  document.getElementById('operado').value = "No";
  document.getElementById('otra_enfermedad').value = "No";
  document.getElementById('licencia_mas').value = "No";
  document.getElementById('medicamento').value = "No";
  document.getElementById('cantidad').value = "No";
  document.getElementById('motivo').value = "No";
}

function inicializarEventListeners() {
  document.getElementById('textoCancer').addEventListener('input', function() {
    if (document.getElementById('cancerSi').checked) {
      document.getElementById('cancer').value = "Si - " + this.value;
    }
  });

  document.getElementById('textoOperado').addEventListener('input', function() {
    if (document.getElementById('operadoSi').checked) {
      document.getElementById('operado').value = "Si - " + this.value;
    }
  });

  document.getElementById('textoOtraEnfermedad').addEventListener('input', function() {
    if (document.getElementById('otraEnfermedadSi').checked) {
      document.getElementById('otra_enfermedad').value = "Si - " + this.value;
    }
  });

  document.getElementById('textoLicenciaMas').addEventListener('input', function() {
    if (document.getElementById('licenciaMasSi').checked) {
      document.getElementById('licencia_mas').value = "Si - " + this.value;
    }
  });
}

function juntarEnfermedades() {
  const enfermedades = [
    { name: 'insuficiencia_cardiaca', label: 'Insuficiencia cardiaca' },
    { name: 'infartos', label: 'Infartos' },
    { name: 'anginas_pecho', label: 'Anginas de pecho' },
    { name: 'arritmias', label: 'Arritmias' }
  ];

  let resultado = [];
  enfermedades.forEach(e => {
    const radios = document.getElementsByName(e.name);
    radios.forEach(radio => {
      if (radio.checked) {
        resultado.push(e.label + ": " + radio.value);
      }
    });
  });

  document.getElementById('enfermedades_corazon').value = resultado.join(', ');
}
document.addEventListener('DOMContentLoaded', () => {
  const grupos = ['profesional', 'no_profesional', 'especiales', 'antes_fecha'];

  grupos.forEach(grupo => {
    const radios = document.querySelectorAll(`input[name="${grupo}"]:not([type="hidden"])`);
    radios.forEach(radio => {
      radio.setAttribute('type', 'checkbox');
    });
  });
});

document.addEventListener('DOMContentLoaded', () => {
  const formulario = document.getElementById('formularioTotal');
  const rutInput = document.getElementById('run');
  const nombreInput = document.getElementById('nombre');
  const firmaImg = document.getElementById('firmaImg');

  rutInput.addEventListener('blur', () => {
    try {
      const limpio = limpiarFormatoRut(rutInput.value.trim());
      validarRut(limpio);
      rutInput.value = limpio;
      rutInput.classList.remove('is-invalid');
      rutInput.classList.add('is-valid');
      alertaRutMostrada = false;
    } catch (error) {
      rutInput.classList.remove('is-valid');
      rutInput.classList.add('is-invalid');
      if (!alertaRutMostrada) {
        alert(error.message);
        alertaRutMostrada = true;
      }
      rutInput.focus();
      rutInput.select();
    }
  });

  nombreInput.addEventListener('input', () => {
    nombreInput.value = nombreInput.value.replace(/[^A-Za-zÁÉÍÓÚÜÑáéíóúüñ'\-\s]/g, '');
  });

  nombreInput.addEventListener('blur', () => {
    nombreInput.value = formatearNombre(nombreInput.value);
    if (nombreValido(nombreInput.value)) {
      nombreInput.classList.remove('is-invalid');
      nombreInput.classList.add('is-valid');
      alertaNombreMostrada = false;
    } else {
      nombreInput.classList.remove('is-valid');
      nombreInput.classList.add('is-invalid');
      if (!alertaNombreMostrada) {
        alert('El nombre debe contener solo letras.');
        alertaNombreMostrada = true;
      }
      nombreInput.focus();
    }
  });

  formulario.addEventListener('submit', async (e) => {
    e.preventDefault();

    const totalPasos = 9;
    let errores = false;
    for (let paso = 1; paso <= totalPasos; paso++) {
      const seccion = document.getElementById(`step${paso}`);
      seccion.classList.add('show', 'active');
      if (!validarCamposStep(paso)) {
        nextStep(paso);
        errores = true;
        break;
      }
      seccion.classList.remove('show', 'active');
    }
    if (errores) {
      alert("Debes completar todos los campos requeridos en todas las secciones.");
      return;
    }

    juntarMedicamentos();
    sincronizarCamposLicencia();

    if (signaturePad && !signaturePad.isEmpty()) {
      firmaImg.value = signaturePad.toDataURL('image/png');
    } else {
      alert("Debe firmar antes de guardar.");
      nextStep(9);
      return;
    }

    const frente = document.getElementById('foto_frente').value;
    const reverso = document.getElementById('foto_reverso').value;
    if (!frente || !reverso) {
      let mensaje = "Debes capturar ";
      if (!frente && !reverso) mensaje += "el anverso y reverso del carnet antes de guardar.";
      else if (!frente) mensaje += "el anverso del carnet antes de guardar.";
      else mensaje += "el reverso del carnet antes de guardar.";
      alert(mensaje);
      nextStep(8);
      return;
    }

    const formData = new FormData(formulario);
    try {
      validarRut(formData.get('run').trim());
    } catch (err) {
      alert(err.message);
      return;
    }

    try {
      const response = await fetch('guardar.php', {
        method: 'POST',
        body: formData
      });
      const resultado = await response.text();

      console.log('Resultado del servidor:', resultado);

      if (response.ok && /guardado|correctamente/i.test(resultado)) {    
        alert('Formulario enviado correctamente:\n' + resultado);
      } else {
        alert('Error en el envío:\n' + resultado);
      }
    } catch (error) {
      alert('Error de red o servidor:\n' + error.message);
    }
  });

  document.querySelectorAll('#bloqueLicencia input[type=radio]').forEach(radio => {
    radio.addEventListener('click', function () {
      if (this.previousChecked) this.checked = false;
      document.querySelectorAll(`#bloqueLicencia input[name="${this.name}"]`).forEach(el => el.previousChecked = false);
      this.previousChecked = this.checked;
    });
  });

  const radios = document.getElementsByName('posee_licencia');
  let checked = Array.from(radios).find(r => r.checked);
  toggleLicencia(checked && checked.value === 'Si');
});

function toggleHabitos(mostrar) {
  const bloque = document.getElementById('bloqueHabitos');
  if (bloque) {
    bloque.style.display = mostrar ? 'block' : 'none';

    if (!mostrar) {
      document.querySelector('select[name="conduce"]').selectedIndex = 0;
      document.querySelectorAll('input[name="utiliza_trabajo"]').forEach(r => r.checked = false);
      document.querySelectorAll('input[name="evaluacion_medica"]').forEach(r => r.checked = false);
      document.querySelector('select[name="conduce_lugar"]').selectedIndex = 0;
      document.querySelectorAll('input[name="accidente"]').forEach(r => r.checked = false);
      document.querySelector('textarea[name="tenido_accidente"]').value = "";

      document.getElementById('detalleAccidente').style.display = 'none';
    }
  }
}

function toggleJornadaSegunSituacion(valor) {
  const jornada = document.getElementById('bloqueJornada');
  const horario = document.getElementById('bloqueHorario');

  const esActivo = (valor === 'Activo(a)');

  jornada.style.display = esActivo ? 'block' : 'none';
  horario.style.display = esActivo ? 'block' : 'none';

  if (!esActivo) {
    document.querySelectorAll('input[name="jornada"]').forEach(el => el.checked = false);
    document.querySelectorAll('input[name="horario"]').forEach(el => el.checked = false);

    document.querySelector('input[name="hidden_jornada"]').value = "";
    document.querySelector('input[name="hidden_horario"]').value = "";
  }
}

function sincronizarCamposLaborales() {
  const jornadaSeleccionada = document.querySelector('input[name="jornada"]:checked');
  const horarioSeleccionado = document.querySelector('input[name="horario"]:checked');

  const inputJornada = document.querySelector('input[name="hidden_jornada"]');
  const inputHorario = document.querySelector('input[name="hidden_horario"]');

  inputJornada.value = jornadaSeleccionada ? jornadaSeleccionada.value : "";
  inputHorario.value = horarioSeleccionado ? horarioSeleccionado.value : "";
}
document.addEventListener('DOMContentLoaded', () => {
  const btnPaso3 = document.querySelector('#step3 .btn.btn-primary.btn-step');

  if (btnPaso3) {
    const originalOnClick = btnPaso3.getAttribute('onclick');

    if (originalOnClick && originalOnClick.includes('validarCamposStep(3)')) {
      btnPaso3.setAttribute('onclick', `
        if (validarCamposStep(3)) {
          sincronizarCamposLaborales();
          nextStep(4);
        }
      `);
    }
  }
});
