<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Http\Request;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * Los tipos de excepción que no se reportan.
     *
     * @var array<int, class-string<\Throwable>>
     */
    protected $dontReport = [
        //
    ];

    /**
     * Una lista de inputs que nunca se incluyen en sesiones de validación.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Registrar los callbacks de reporte de excepciones para la aplicación.
     */
    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    /**
     * Renderizar una excepción en una respuesta HTTP.
     */
    public function render($request, Throwable $exception)
    {
        // Manejar errores 404 en rutas de admin
        if ($exception instanceof NotFoundHttpException) {
            if ($request->is('admin/*')) {
                return response()->view('errors.admin-404', [], 404);
            }
        }

        return parent::render($request, $exception);
    }
}
