<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Gestion extends Model
{
    protected $fillable = [
        'solicitud_id',
        'usuario_id',
        'fecha_gestion',
        'accion_realizada',
        'descripcion_gestion',
        'usuario_gestion',
        'uri_archivos_adjuntos'
    ];

    protected $table = 'gestiones';

    protected $casts = [
        'fecha_gestion' => 'datetime',
    ];

    public function solicitud()
    {
        return $this->belongsTo(Solicitud::class, 'solicitud_id');
    }

    public function usuario()
    {
        return $this->belongsTo(\App\Models\User::class, 'usuario_id');
    }

    /**
     * Obtener la fecha de gestión formateada
     */
    public function getFechaFormateadaAttribute()
    {
        if (!$this->fecha_gestion) {
            return 'Sin fecha';
        }
        
        return $this->fecha_gestion->format('d/m/Y H:i');
    }

    /**
     * Accessor para asegurar que fecha_gestion siempre sea un Carbon instance
     */
    public function getFechaGestionAttribute($value)
    {
        if (!$value) {
            return null;
        }
        
        if (is_string($value)) {
            return \Carbon\Carbon::parse($value);
        }
        
        return $value;
    }
}
