<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('solicitudes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tipo_solicitud_id')->constrained('tipo_solicitudes');
            $table->foreignId('organismo_requeridor_id')->constrained('organismos');
            $table->boolean('notificacion');
            $table->text('detalle_solicitud');
            $table->date('fecha_solicitud');
            $table->text('observaciones')->nullable();
            // Datos de contacto
            $table->string('nombres');
            $table->string('apellido_paterno');
            $table->string('apellido_materno')->nullable();
            $table->string('nacionalidad')->nullable();
            $table->string('pais_residencia')->nullable();
            $table->string('calle')->nullable();
            $table->string('numero')->nullable();
            $table->string('villa')->nullable();
            $table->string('comuna')->nullable();
            $table->string('telefono')->nullable();
            $table->string('email');
            // Datos estadísticos (opcionales)
            $table->string('tipo_zona')->nullable();
            $table->string('educacion')->nullable();
            $table->string('edad')->nullable();
            $table->string('ocupacion')->nullable();
            $table->string('genero')->nullable();
            $table->boolean('organizacion')->nullable();
            $table->boolean('apoderado')->nullable();
            $table->string('usuario_respuesta')->nullable();
            $table->string('estado')->default('pendiente');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('solicitudes');
    }
};
