// Funcionalidad para el formulario de crear/editar tipos de solicitudes
document.addEventListener('DOMContentLoaded', function() {
    // Manejar notificaciones
    handleNotifications();
    
    // Validación del formulario
    initFormValidation();
});

function handleNotifications() {
    if (window.successMessage) {
        Swal.fire({
            icon: 'success',
            title: '¡Éxito!',
            text: window.successMessage,
            timer: 3000,
            showConfirmButton: false
        });
    }
    
    if (window.errorMessages) {
        Swal.fire({
            icon: 'error',
            title: 'Errores de validación',
            html: window.errorMessages
        });
    }
}

function initFormValidation() {
    const form = document.querySelector('form');
    if (!form) return;
    
    form.addEventListener('submit', function(e) {
        const denominacion = document.getElementById('denominacion').value.trim();
        
        if (!denominacion) {
            e.preventDefault();
            Swal.fire({
                icon: 'warning',
                title: 'Campo requerido',
                text: 'La denominación es obligatoria.'
            });
            return false;
        }
    });
}
