{{-- Panel de filtros --}}
<div class="card border-0 shadow-sm mb-3 filters-panel">
    <div class="card-body py-3">
        <form method="GET" class="row g-3 align-items-end">
            <div class="col-md-6 col-lg-5">
                <label class="form-label text-muted font-weight-semibold mb-1">Ordenar solicitudes activas:</label>
                <select name="order" class="form-control form-control-sm" onchange="this.form.submit()">
                    <option value="recientes"{{ request('order','recientes')=='recientes' ? ' selected' : '' }}>Más recientes</option>
                    <option value="antiguas"{{ request('order')=='antiguas' ? ' selected' : '' }}>Más antiguas</option>
                </select>
            </div>
            <div class="col-md-6 col-lg-4">
                <label class="form-label text-muted font-weight-semibold mb-1">Filtrar por estado:</label>
                <select name="estado" class="form-control form-control-sm" onchange="this.form.submit()">
                    <option value="">Todos los estados</option>
                    <option value="pendiente"{{ request('estado')=='pendiente' ? ' selected' : '' }}>Pendiente</option>
                    <option value="en_gestion"{{ request('estado')=='en_gestion' ? ' selected' : '' }}>En gestión</option>
                    <option value="cerrada"{{ request('estado')=='cerrada' ? ' selected' : '' }}>Cerrada</option>
                </select>
            </div>
            <div class="col-md-12 col-lg-3">
                <div class="d-flex align-items-center justify-content-lg-end">
                    <small class="filter-summary">
                        <i class="fas fa-filter mr-1"></i>
                        Total: <strong>{{ $solicitudes->total() }}</strong> solicitudes
                    </small>
                </div>
            </div>
        </form>
    </div>
</div>

{{-- Mensaje de éxito --}}
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif
</div>
