{{-- Acciones de la fila de la tabla --}}
<div class="btn-group" role="group">
    <button type="button" class="btn btn-sm btn-outline-primary" data-toggle="modal" data-target="#modalResumen{{ $solicitud->id }}" title="Ver Detalle">
        <i class="fas fa-eye"></i>
    </button>
    
    @if(!$solicitud->gestor_id)
        <form action="{{ route('admin.solicitudes.gestionar', $solicitud->id) }}" method="POST" style="display:inline-block;">
            @csrf
            <button type="submit" class="btn btn-sm btn-outline-success" title="Gestionar">
                <i class="fas fa-play"></i>
            </button>
        </form>
    @else
        <button type="button" class="btn btn-sm btn-outline-info" data-toggle="modal" data-target="#modalGestion{{ $solicitud->id }}" title="Ver Gestión">
            <i class="fas fa-tasks"></i>
        </button>
        @if($solicitud->estado !== 'cerrada' && $solicitud->gestor_id === auth()->id())
            <button type="button" class="btn btn-sm btn-outline-danger cerrar-solicitud-btn" 
                    data-solicitud-id="{{ $solicitud->id }}" 
                    data-solicitud-numero="#{{ $solicitud->id }}"
                    title="Cerrar">
                <i class="fas fa-times"></i>
            </button>
        @elseif($solicitud->estado !== 'cerrada')
            <span class="btn btn-sm btn-outline-secondary disabled" title="Solo el gestor asignado puede cerrar esta solicitud">
                <i class="fas fa-lock"></i>
            </span>
        @endif
    @endif
</div>
