@extends('layouts.admin')

@section('title', 'Usuarios')

@push('styles')
    @vite(['resources/css/admin-users.css'])
@endpush

@section('content')
<div class="users-header">
    <h2 class="text-gray font-weight-bold">Usuarios</h2>
    
    <div class="d-flex justify-content-end">
        <a href="{{ route('admin.users.create') }}" class="btn btn-primary">
            Nuevo <i class="fas fa-plus"></i>
        </a>
    </div>
    
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    
    <div class="admin-responsive-table table-scroll-indicator">
        <table class="table table-bordered table-striped users-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nombres</th>
                    <th>Apellidos</th>
                    <th>Email</th>
                    <th>Teléfono</th>
                    <th>Rol</th>
                    <th class="expandable-cell">Organismo</th>
                    <th class="actions-cell">Acciones</th>
                </tr>
            </thead>
        <tbody>
            @foreach($users as $user)
                <tr>
                    <td>{{ $user->id }}</td>
                    <td>{{ $user->first_name }}</td>
                    <td>{{ $user->last_name }}</td>
                    <td>{{ $user->email }}</td>
                    <td>{{ $user->telefono ?: '-' }}</td>
                    <td>{{ ucfirst($user->role) }}</td>
                    <td>{{ $user->organismo?->nombre ?? '-' }}</td>
                    <td class="actions-cell">
                        <a href="{{ route('admin.users.edit', $user->id) }}" 
                           class="btn btn-sm btn-action btn-edit"
                           title="Editar usuario">
                            <i class="fas fa-edit"></i>
                        </a>
                        <form action="{{ route('admin.users.destroy', $user->id) }}" 
                              method="POST" 
                              style="display:inline-block;"
                              class="delete-user-form">
                            @csrf
                            @method('DELETE')
                            <button type="submit" 
                                    class="btn btn-sm btn-action btn-delete"
                                    title="Eliminar usuario">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
    </div>
    
    @if($users->hasPages())
        <div class="pagination-wrapper">
            {{ $users->links() }}
        </div>
    @endif
</div>
@endsection

@push('scripts')
    @vite(['resources/js/admin-users.js'])
    <script>
        // Variables globales para el contexto
        window.successMessage = @json(session('success'));
        window.errorMessage = @json(session('error'));
        window.errorMessages = @json($errors->any() ? implode('<br>', $errors->all()) : null);
    </script>
@endpush
