<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Solicitud Recibida - SIAC</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
        }
        
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            width: 100%;
        }
        
        .header {
            background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
            color: white;
            padding: 25px 20px;
            text-align: center;
        }
        
        .header h1 {
            font-size: clamp(20px, 4vw, 24px);
            margin-bottom: 10px;
            line-height: 1.3;
        }
        
        .header .subtitle {
            font-size: clamp(14px, 3vw, 16px);
            opacity: 0.9;
            line-height: 1.4;
        }
        
        .content {
            padding: 30px 20px;
        }
        
        .greeting {
            font-size: clamp(16px, 3.5vw, 18px);
            margin-bottom: 20px;
            color: #2c3e50;
            line-height: 1.4;
        }
        
        .message {
            background-color: #e3f2fd;
            border-left: 4px solid #007bff;
            padding: 20px 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
        
        .message .icon {
            font-size: clamp(20px, 4vw, 24px);
            margin-bottom: 10px;
            color: #007bff;
        }
        
        .details {
            background-color: #f8f9fa;
            border-radius: 8px;
            padding: 20px 15px;
            margin: 20px 0;
        }
        
        .details h3 {
            margin-bottom: 20px;
            color: #2c3e50;
            border-bottom: 2px solid #007bff;
            padding-bottom: 10px;
            font-size: clamp(16px, 3.5vw, 18px);
        }
        
        .detail-row {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 15px;
            padding: 12px 0;
            border-bottom: 1px solid #e9ecef;
            flex-wrap: wrap;
            gap: 8px;
        }
        
        .detail-row:last-child {
            border-bottom: none;
            margin-bottom: 0;
        }
        
        .detail-label {
            font-weight: 600;
            color: #495057;
            flex: 1;
            min-width: 120px;
        }
        
        .detail-value {
            text-align: right;
            color: #212529;
            flex: 1.5;
            min-width: 150px;
            word-wrap: break-word;
        }
        
        .status-badge {
            background-color: #ffc107;
            color: #212529;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: clamp(11px, 2.5vw, 12px);
            font-weight: 600;
            text-transform: uppercase;
            display: inline-block;
            white-space: nowrap;
        }
        
        .footer {
            background-color: #2c3e50;
            color: #ecf0f1;
            padding: 25px 20px;
            text-align: center;
        }
        
        .footer p {
            margin-bottom: 10px;
            font-size: clamp(13px, 3vw, 14px);
            line-height: 1.5;
        }
        
        .footer .contact {
            font-size: clamp(12px, 2.8vw, 14px);
            opacity: 0.8;
            line-height: 1.6;
        }
        
        .btn {
            display: inline-block;
            padding: 12px 20px;
            background: linear-gradient(135deg, #28a745 0%, #1e7e34 100%);
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: 600;
            margin: 20px 0;
            transition: all 0.3s ease;
            font-size: clamp(14px, 3vw, 16px);
            text-align: center;
            max-width: 200px;
            width: 100%;
        }
        
        .next-steps {
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
            border-radius: 8px;
            padding: 20px 15px;
            margin: 20px 0;
        }
        
        .next-steps h4 {
            color: #155724;
            margin-bottom: 15px;
            font-size: clamp(15px, 3.2vw, 16px);
            line-height: 1.4;
        }
        
        .next-steps ul {
            margin: 0;
            padding-left: 20px;
            color: #155724;
        }
        
        .next-steps li {
            margin-bottom: 10px;
            line-height: 1.6;
            font-size: clamp(13px, 3vw, 14px);
        }
        
        /* Estilos para alertas y notificaciones */
        .alert-warning {
            background-color: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 8px;
            padding: 20px 15px;
            margin: 20px 0;
        }
        
        .alert-warning p {
            margin: 0;
            color: #856404;
            font-size: clamp(13px, 3vw, 14px);
            line-height: 1.6;
        }
        
        /* Media Queries para responsive */
        @media (max-width: 600px) {
            .container {
                margin: 0;
                border-radius: 0;
                width: 100% !important;
            }
            
            .content, .header, .footer {
                padding: 20px 15px !important;
            }
            
            .details, .message, .next-steps, .alert-warning {
                padding: 15px !important;
                margin: 15px 0 !important;
            }
            
            .detail-row {
                flex-direction: column;
                align-items: flex-start;
                gap: 5px;
                padding: 10px 0;
            }
            
            .detail-label {
                min-width: unset;
                font-size: 14px;
            }
            
            .detail-value {
                text-align: left !important;
                margin-top: 5px;
                font-size: 14px;
                word-break: break-word;
            }
            
            .status-badge {
                margin-top: 5px;
                font-size: 11px !important;
            }
            
            .btn {
                width: 100%;
                max-width: none;
                padding: 15px 20px;
                font-size: 16px !important;
                box-sizing: border-box;
            }
            
            .next-steps ul {
                padding-left: 15px;
            }
            
            .next-steps li {
                font-size: 13px !important;
                margin-bottom: 12px;
            }
            
            .footer .contact {
                line-height: 1.8;
                word-break: break-word;
            }
        }
        
        @media (max-width: 480px) {
            .content, .header, .footer {
                padding: 15px 10px !important;
            }
            
            .details, .message, .next-steps, .alert-warning {
                padding: 12px !important;
                margin: 12px 0 !important;
            }
            
            .header h1 {
                font-size: 18px !important;
                margin-bottom: 8px;
            }
            
            .header .subtitle {
                font-size: 14px !important;
            }
            
            .greeting {
                font-size: 16px !important;
                margin-bottom: 15px;
            }
            
            .details h3 {
                font-size: 16px !important;
                margin-bottom: 15px;
            }
            
            .detail-row {
                padding: 8px 0;
            }
            
            .detail-label, .detail-value {
                font-size: 13px !important;
            }
            
            .next-steps h4 {
                font-size: 15px !important;
            }
            
            .footer p {
                font-size: 12px !important;
            }
        }
        
        /* Mejoras adicionales para clientes de email */
        @media screen and (max-width: 320px) {
            .container {
                min-width: 280px !important;
            }
            
            .content, .header, .footer {
                padding: 10px !important;
            }
            
            .detail-row {
                border-bottom: 1px dotted #e9ecef;
            }
            
            .status-badge {
                padding: 4px 8px;
                font-size: 10px !important;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1>📨 Solicitud Recibida</h1>
            <p class="subtitle">Sistema Integrado de Atención Ciudadana</p>
        </div>

        <!-- Content -->
        <div class="content">
            <div class="greeting">
                Estimado/a {{ $solicitante_nombre }},
            </div>

            <div class="message">
                <div class="icon">✅</div>
                <p><strong>¡Su solicitud ha sido recibida exitosamente!</strong> Hemos registrado su requerimiento en nuestro sistema y será procesado a la brevedad.</p>
            </div>

            <p>Le confirmamos que hemos recibido su solicitud y que será atendida por el organismo correspondiente. A continuación, encontrará los detalles de su solicitud:</p>

            <!-- Detalles de la solicitud -->
            <div class="details">
                <h3>📋 Detalles de la Solicitud</h3>
                
                <div class="detail-row">
                    <span class="detail-label">Número de Solicitud:</span>
                    <span class="detail-value"><strong>#{{ $solicitud->id }}</strong></span>
                </div>
                
                <div class="detail-row">
                    <span class="detail-label">Código de Seguimiento:</span>
                    <span class="detail-value"><strong>{{ $codigo_seguimiento }}</strong></span>
                </div>
                
                <div class="detail-row">
                    <span class="detail-label">Tipo de Solicitud:</span>
                    <span class="detail-value">{{ $tipo_solicitud }}</span>
                </div>
                
                <div class="detail-row">
                    <span class="detail-label">Organismo:</span>
                    <span class="detail-value">{{ $organismo }}</span>
                </div>
                
                <div class="detail-row">
                    <span class="detail-label">Estado:</span>
                    <span class="detail-value">
                        <span class="status-badge">Ingresada</span>
                    </span>
                </div>
                
                <div class="detail-row">
                    <span class="detail-label">Fecha de Ingreso:</span>
                    <span class="detail-value">{{ $solicitud->created_at->format('d/m/Y H:i') }}</span>
                </div>
                
                @if($solicitud->detalle_solicitud)
                <div class="detail-row">
                    <span class="detail-label">Detalle:</span>
                    <span class="detail-value">{{ \Str::limit($solicitud->detalle_solicitud, 100) }}</span>
                </div>
                @endif
            </div>

            <!-- Seguimiento Online -->
            <div class="next-steps" style="background: #e8f4fd; border-left: 4px solid #007bff;">
                <h4>🔍 Seguimiento en Línea</h4>
                <p><strong>Puede seguir el estado de su solicitud en cualquier momento visitando:</strong></p>
                <div style="text-align: center; margin: 15px 0;">
                    <a href="{{ $url_seguimiento }}" style="display: inline-block; background: #007bff; color: white; padding: 12px 25px; text-decoration: none; border-radius: 5px; font-weight: bold;">
                        🔗 Ver Estado de Mi Solicitud
                    </a>
                </div>
                <p style="font-size: 14px; color: #666;">
                    O ingrese manualmente su código de seguimiento <strong>{{ $codigo_seguimiento }}</strong> en: 
                    <a href="{{ route('seguimiento.buscar') }}">{{ route('seguimiento.buscar') }}</a>
                </p>
            </div>

            <!-- Próximos pasos -->
            <div class="next-steps">
                <h4>🔄 Próximos Pasos</h4>
                <ul>
                    <li><strong>Revisión inicial:</strong> Su solicitud será revisada y asignada a un gestor especializado</li>
                    <li><strong>Procesamiento:</strong> El organismo correspondiente analizará y procesará su requerimiento</li>
                    <li><strong>Notificaciones:</strong> Recibirá actualizaciones por correo electrónico sobre el progreso</li>
                    <li><strong>Resolución:</strong> Una vez completada, recibirá la respuesta final en este mismo correo</li>
                </ul>
            </div>

            <p><strong>Tiempo estimado de respuesta:</strong> 
                @if(isset($tiempo_limite_dias))
                    {{ $tiempo_limite_dias }} días hábiles
                @else
                    Será informado una vez que se asigne un gestor
                @endif
            </p>

            <p>Si tiene alguna consulta sobre esta solicitud, puede contactarnos indicando el <strong>código de seguimiento {{ $codigo_seguimiento }}</strong>.</p>

            <div class="alert-warning">
                <p><strong>📧 Importante:</strong> Guarde este código de seguimiento para consultar el estado de su solicitud en cualquier momento. Se le notificará automáticamente sobre cualquier actualización en el estado de su requerimiento.</p>
            </div>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p><strong>Sistema Integrado de Atención Ciudadana (SIAC)</strong></p>
            <p><strong>Municipalidad de Loncoche</strong></p>
            <p class="contact">
                📧 siac@muniloncochedigital.cl | 📞 +56452406565<br>
                🌐 https://municipalidaddeloncoche.cl/
            </p>
            <p style="font-size: 12px; opacity: 0.7; margin-top: 20px;">
                © {{ date('Y') }} SIAC. Todos los derechos reservados.<br>
                Este mensaje fue enviado a {{ $solicitud->email }}
            </p>
        </div>
    </div>
</body>
</html>
