{{-- resources/views/layouts/admin.blade.php --}}
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Panel de Administración')</title>
    <!-- Bootstrap CSS desde AdminLTE -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/css/bootstrap.min.css">
    <!-- FontAwesome -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/plugins/fontawesome-free/css/all.min.css') }}">
    <!-- AdminLTE CSS -->
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/css/adminlte.min.css') }}">
    @stack('styles')
    @yield('styles')
</head>

<body class="hold-transition sidebar-mini">
    <div class="wrapper">
        @include('admin.partials.navbar')
        @include('admin.partials.sidebar')
        <div class="content-wrapper">
            <section class="content pt-3">
                <div class="container-fluid">
                    @yield('content')
                    {{-- Toasts globales --}}
                    @php
                        $toastScripts = [];
                        if(session('success')) {
                            $toastScripts[] = "showToast({text: " . json_encode(session('success')) . ", icon: 'success', timer: 4000});";
                        }
                        foreach($errors->all() as $error) {
                            $toastScripts[] = "showToast({text: " . json_encode($error) . ", icon: 'error', timer: 5000});";
                        }
                    @endphp
                    @if(count($toastScripts))
                        <script>
                            document.addEventListener('DOMContentLoaded', function() {
                                {!! implode("\n                                ", $toastScripts) !!}
                            });
                        </script>
                    @endif
                </div>
            </section>
        </div>
        <footer class="main-footer">
            <div class="float-right d-none d-sm-block">
                <b>Versión</b> 1.0
            </div>
            <strong>SIAC &copy; {{ date('Y') }}</strong>
        </footer>
    </div>
    <!-- jQuery, Bootstrap JS y AdminLTE JS (en orden correcto) -->
    <script src="{{ asset('vendor/adminlte/plugins/jquery/jquery.min.js') }}"></script>
    <script src="{{ asset('vendor/adminlte/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('vendor/adminlte/js/adminlte.min.js') }}"></script>
    <!-- SweetAlert2 (para toast) -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="/js/toast-handler.js"></script>
    @stack('scripts')
    @yield('scripts')
</body>

</html>