@extends('layouts.confirmation')
@section('title', 'Solicitud enviada')
@section('content')

<div class="siac-app-card" style="background: white; border-radius: 16px; box-shadow: 0 20px 40px rgba(0,0,0,0.1); overflow: hidden; margin-top: 3rem;">
    <div class="siac-form" style="padding: 3rem 2rem;">
        <div style="text-align: center; margin-bottom: 2rem;">
            <div style="width: 80px; height: 80px; background: #28a745; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 1.5rem;">
                <i class="fas fa-check" style="font-size: 2rem; color: white;"></i>
            </div>
            <h1 style="font-size: 2rem; font-weight: 700; color: #1a3766; margin-bottom: 1rem;">
                ¡Solicitud Enviada Exitosamente!
            </h1>
        </div>
        
        <div style="text-align: center; margin-bottom: 3rem;">
            <p style="font-size: 1.1rem; color: #4a5568; margin-bottom: 1rem; line-height: 1.6;">
                Tu solicitud ha sido registrada correctamente en nuestro sistema.
            </p>
            <p style="color: #718096; margin-bottom: 0; line-height: 1.6;">
                Recibirás notificaciones sobre el progreso de tu solicitud a través del correo electrónico proporcionado.
                Nuestro equipo se pondrá en contacto contigo lo antes posible.
            </p>
        </div>
        
        <div style="text-align: center;">
            <a href="{{ route('home') }}" 
               style="background: #007bff; color: white; padding: 1rem 2rem; border-radius: 8px; text-decoration: none; font-weight: 600; display: inline-flex; align-items: center; justify-content: center; transition: all 0.3s ease; box-shadow: 0 4px 12px rgba(0,123,255,0.3);"
               onmouseover="this.style.background='#0056b3'; this.style.transform='translateY(-2px)';"
               onmouseout="this.style.background='#007bff'; this.style.transform='translateY(0)';">
                <i class="fas fa-home" style="margin-right: 0.5rem;"></i>
                Volver a la Página Principal
            </a>
        </div>
        
        <div style="text-align: center; margin-top: 2rem; padding-top: 2rem; border-top: 1px solid #e2e8f0;">
            <div style="display: flex; align-items: center; justify-content: center; gap: 1rem;">
                <img src="{{ asset('images/logo.png') }}" alt="Logo SIAC" style="width: 40px; height: 40px; border-radius: 50%;">
                <div style="text-align: left;">
                    <div style="font-weight: 600; color: #1a3766; font-size: 0.9rem;">Sistema Integral de Atención Ciudadana</div>
                    <div style="color: #718096; font-size: 0.8rem;">Municipalidad de Loncoche</div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
