@extends('layouts.app')
@section('title', 'Sistema de Atención Ciudadana')

@section('content')
<div class="siac-app-card siac-view-welcome" style="margin-bottom: 6rem;">
    <div class="siac-form-welcome">

        
        <div style="text-align: center; margin-bottom: 3rem;">
            <p style="font-size: 1.1rem; color: #666; line-height: 1.6;">
                Seleccione la opción que necesita:
            </p>
        </div>

        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 2rem; margin-bottom: 2rem;">
            <!-- Nueva Solicitud -->
            <div style="text-align: center; padding: 2rem; border: 2px solid #e9ecef; border-radius: 12px; transition: transform 0.2s, border-color 0.2s;">
                <div style="font-size: 3rem; margin-bottom: 1rem;">📝</div>
                <h3 style="color: #1a3766; margin-bottom: 1rem;">Nueva Solicitud</h3>
                <p style="color: #666; margin-bottom: 1.5rem; line-height: 1.5;">
                    Crear una nueva solicitud de información o servicio municipal
                </p>
                <a href="{{ route('solicitudes.create.details') }}" class="siac-btn-option" style="text-decoration: none;">
                    Iniciar
                </a>
            </div>

            <!-- Seguimiento -->
            <div style="text-align: center; padding: 2rem; border: 2px solid #e9ecef; border-radius: 12px; transition: transform 0.2s, border-color 0.2s;">
                <div style="font-size: 3rem; margin-bottom: 1rem;">🔍</div>
                <h3 style="color: #1a3766; margin-bottom: 1rem;">Seguir Mi Solicitud</h3>
                <p style="color: #666; margin-bottom: 1.5rem; line-height: 1.5;">
                    Consultar el estado de una solicitud existente usando su código de seguimiento
                </p>
                <a href="{{ route('seguimiento.buscar') }}" class="siac-btn-option" style="text-decoration: none; background: #28a745;">
                    Consultar
                </a>
            </div>
        </div>

        <div style="background: #f8f9fa; padding: 1.5rem; border-radius: 8px; margin-top: 2rem;">
            <h4 style="color: #1a3766; margin-bottom: 1rem;">💡 Información Importante</h4>
            <ul style="margin: 0; padding-left: 1.5rem; color: #666;">
                <li style="margin-bottom: 0.5rem;">Al crear una solicitud recibirá un código de seguimiento por correo electrónico</li>
                <li style="margin-bottom: 0.5rem;">Puede usar este código para consultar el estado de su solicitud en cualquier momento</li>
                <li style="margin-bottom: 0.5rem;">Recibirá notificaciones automáticas sobre actualizaciones en su solicitud</li>
                <li>Todas las solicitudes son procesadas por los organismos municipales correspondientes</li>
            </ul>
        </div>
    </div>

    <!-- Panel Institucional -->
    <div class="siac-info-panel">
        <img src="/images/logo.png" alt="Logo Municipalidad de Loncoche" class="logo-muni">
        <div class="siac-info-title">Municipalidad de Loncoche</div>
        <div class="siac-info-subtitle">Sistema de Información y Atención Ciudadana</div>
        <div class="siac-info-desc">
            Plataforma oficial para realizar solicitudes de información pública, servicios municipales 
            y otros trámites ciudadanos de manera digital y transparente.
        </div>
        <img src="/images/logo-copihue.png" alt="Loncoche" class="siac-info-img">
    </div>
</div>

<style>

.siac-btn-option {
    display: inline-block;
    padding: 0.75rem 1.5rem;
    min-width: 150px;
    background-color: #007bff;
    color: #fff;
    border-radius: 8px;
    text-decoration: none;
    transition: background-color 0.2s, transform 0.2s;
}
.siac-btn-option:hover {
    background-color: #0056b3;
    transform: translateY(-2px);
}

</style>
@endsection
