
<?php if(!$solicitud->gestor_id): ?>
    <form action="<?php echo e(route('admin.solicitudes.gestionar', $solicitud->id)); ?>" method="POST" style="display:inline-block; position: relative; z-index: 10004;">
        <?php echo csrf_field(); ?>
        <button type="submit" class="btn btn-success mr-2" style="position: relative; z-index: 10005;">
            <i class="fas fa-play mr-1"></i>Comenzar Gestión
        </button>
    </form>
<?php else: ?>
    <a href="<?php echo e(route('admin.solicitudes.show', $solicitud->id)); ?>" class="btn btn-info mr-2" style="position: relative; z-index: 10005;">
        <i class="fas fa-tasks mr-1"></i>Ver Gestión Completa
    </a>
    <?php if($solicitud->estado !== 'cerrada' && $solicitud->gestor_id === auth()->id()): ?>
        <button type="button" class="btn btn-warning mr-2 cerrar-solicitud-btn" 
                data-solicitud-id="<?php echo e($solicitud->id); ?>" 
                data-solicitud-numero="#<?php echo e($solicitud->id); ?>"
                style="position: relative; z-index: 10005;">
            <i class="fas fa-times mr-1"></i>Cerrar Solicitud
        </button>
    <?php elseif($solicitud->estado !== 'cerrada'): ?>
        <div class="alert alert-info mb-0 mr-2" style="position: relative; z-index: 10004;">
            <i class="fas fa-info-circle mr-1"></i>
            Solo <strong><?php echo e($solicitud->gestor->name); ?></strong> puede cerrar esta solicitud
        </div>
    <?php endif; ?>
<?php endif; ?>
<button type="button" class="btn btn-secondary" data-dismiss="modal" style="position: relative; z-index: 10005;">
    <i class="fas fa-times mr-1"></i>Cerrar
</button>
<?php /**PATH /var/www/html/siac/resources/views/admin/solicitudes/partials/modal-footer-actions.blade.php ENDPATH**/ ?>