<?php $__env->startSection('title', 'Seguimiento de Solicitud'); ?>

<?php $__env->startSection('content'); ?>
<div class="siac-app-card siac-view-seguimiento">
    <form class="siac-form" action="<?php echo e(route('seguimiento.consultar')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        
        <!-- Título simplificado sin badge -->
        <h1 class="siac-search-title">Seguimiento de Solicitud</h1>
        
        <div>
            <label class="siac-form-label" for="codigo_seguimiento">Código de Seguimiento</label>
            <input type="text" name="codigo_seguimiento" id="codigo_seguimiento" class="siac-form-input" 
                   value="<?php echo e(old('codigo_seguimiento')); ?>" 
                   placeholder="Ej: SIAC-20250726-A1B2" 
                   style="text-transform: uppercase;"
                   required>
            <div class="form-field-info">
                Ingrese el código de seguimiento que recibió por correo electrónico al crear su solicitud.
            </div>

            <?php if($errors->has('codigo_seguimiento')): ?>
                <div class="error-message">
                    <?php echo e($errors->first('codigo_seguimiento')); ?>

                </div>
            <?php endif; ?>
        </div>

        <button type="submit" class="siac-form-btn">Buscar Solicitud</button>
    </form>

    <!-- Panel Institucional Simplificado -->
    <div class="siac-info-panel">
        <img src="/images/logo.png" alt="Logo Municipalidad de Loncoche" class="logo-muni">
        <div class="siac-info-title">Municipalidad de Loncoche</div>
        <div class="siac-info-subtitle">Sistema de Información y Atención Ciudadana</div>
    </div>
</div>

<script>
// Convertir a mayúsculas automáticamente
document.getElementById('codigo_seguimiento').addEventListener('input', function(e) {
    e.target.value = e.target.value.toUpperCase();
});

// Mostrar toast para mensajes de error o validación
document.addEventListener('DOMContentLoaded', function() {
    <?php if(session('error')): ?>
        showErrorToast('<?php echo e(session('error')); ?>');
    <?php endif; ?>
    
    <?php if($errors->has('codigo_seguimiento')): ?>
        showWarningToast('<?php echo e($errors->first('codigo_seguimiento')); ?>');
    <?php endif; ?>
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/siac/resources/views/seguimiento/buscar.blade.php ENDPATH**/ ?>