
<?php if($solicitud->estado == 'cerrada'): ?>
    <span class="badge badge-secondary badge-pill px-2 py-1">
        <i class="fas fa-check-circle mr-1"></i>Finalizada
    </span>
<?php else: ?>
    <?php
        $limite = $solicitud->fecha_asignacion ?? $solicitud->created_at;
        $horasLimite = $solicitud->tiempo_limite_horas ?? 168;
        $limite = \Carbon\Carbon::parse($limite)->addHours($horasLimite);
        $totalDias = ceil($horasLimite / 24);
        $diasRestantes = now()->diffInDays($limite, false);
        
        $badgeColor = 'success';
        if ($diasRestantes <= ($totalDias * 0.25)) {
            $badgeColor = 'danger';
        } elseif ($diasRestantes <= ($totalDias * 0.5)) {
            $badgeColor = 'warning';
        }
        if ($limite->isPast()) {
            $badgeColor = 'danger';
            $diasRestantes = 0;
        }
    ?>
    <?php if($limite->isPast()): ?>
        <span class="badge bg-danger badge-pill px-2 py-1">
            <i class="fas fa-exclamation-triangle mr-1"></i>Vencida
        </span>
    <?php else: ?>
        <span class="badge bg-<?php echo e($badgeColor); ?> badge-pill px-2 py-1">
            <i class="fas fa-clock mr-1"></i><?php echo e(max(0, intval($diasRestantes))); ?> días
        </span>
    <?php endif; ?>
<?php endif; ?>
<?php /**PATH /var/www/html/siac/resources/views/admin/solicitudes/partials/tiempo-restante.blade.php ENDPATH**/ ?>