
<div class="card shadow-sm border-0 mb-4">
    <div class="card-header bg-light">
        <h6 class="mb-0 text-primary"><i class="fas fa-info-circle mr-2"></i>Información General</h6>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6 mb-3">
                <label class="text-muted small mb-1">Tipo de Solicitud</label>
                <div class="font-weight-bold"><?php echo e($solicitud->tipoSolicitud->denominacion ?? '-'); ?></div>
            </div>
            <div class="col-md-6 mb-3">
                <label class="text-muted small mb-1">Organismo Requeridor</label>
                <div class="font-weight-bold"><?php echo e($solicitud->organismoRequeridor->nombre ?? '-'); ?></div>
            </div>
            <div class="col-md-4 mb-3">
                <label class="text-muted small mb-1">Estado</label>
                <div>
                    <?php echo $__env->make('admin.solicitudes.partials.estado-badge', ['solicitud' => $solicitud], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <label class="text-muted small mb-1">Fecha de Solicitud</label>
                <div><?php echo e(\Carbon\Carbon::parse($solicitud->fecha_solicitud)->format('d/m/Y')); ?></div>
            </div>
            <div class="col-md-4 mb-3">
                <label class="text-muted small mb-1">Tiempo Restante</label>
                <div>
                    <?php echo $__env->make('admin.solicitudes.partials.tiempo-restante', ['solicitud' => $solicitud], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
            </div>
            <div class="col-md-6 mb-3">
                <label class="text-muted small mb-1">Gestor Asignado</label>
                <div>
                    <?php if($solicitud->gestor): ?>
                        <span class="badge badge-secondary"><i class="fas fa-user mr-1"></i><?php echo e($solicitud->gestor->name); ?></span>
                    <?php else: ?>
                        <span class="text-muted">Sin asignar</span>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-6 mb-3">
                <label class="text-muted small mb-1">Fecha de Asignación</label>
                <div><?php echo e($solicitud->fecha_asignacion ? \Carbon\Carbon::parse($solicitud->fecha_asignacion)->format('d/m/Y H:i') : '-'); ?></div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /var/www/html/siac/resources/views/admin/solicitudes/partials/modal-info-general.blade.php ENDPATH**/ ?>