<?php $__env->startSection('title', 'Datos de Contacto'); ?>

<?php $__env->startSection('content'); ?>

<div class="siac-app-card siac-view-contact" style="margin-bottom: 6rem;">
  <!-- Formulario -->
  <form class="siac-form" action="<?php echo e(route('solicitudes.storeContact')); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <div class="siac-form-label-title" style="margin-bottom:1.5rem;">Datos de Contacto</div>
    
    <label class="siac-form-label" for="nombres">Nombres *</label>
    <input type="text" name="nombres" id="nombres" class="siac-form-input" value="<?php echo e(old('nombres')); ?>" required>

    <label class="siac-form-label" for="apellido_paterno">Apellido Paterno *</label>
    <input type="text" name="apellido_paterno" id="apellido_paterno" class="siac-form-input" value="<?php echo e(old('apellido_paterno')); ?>" required>

    <label class="siac-form-label" for="apellido_materno">Apellido Materno</label>
    <input type="text" name="apellido_materno" id="apellido_materno" class="siac-form-input" value="<?php echo e(old('apellido_materno')); ?>">

    <label class="siac-form-label" for="pais_residencia">País de residencia</label>
    <input type="text" name="pais_residencia" id="pais_residencia" class="siac-form-input" value="Chile" readonly>

    <label class="siac-form-label" for="calle">Calle *</label>
    <input type="text" name="calle" id="calle" class="siac-form-input" value="<?php echo e(old('calle')); ?>" required>

    <label class="siac-form-label" for="numero">Número *</label>
    <input type="text" name="numero" id="numero" class="siac-form-input" value="<?php echo e(old('numero')); ?>" required>

    <label class="siac-form-label" for="villa">Villa / Población / Departamento</label>
    <input type="text" name="villa" id="villa" class="siac-form-input" value="<?php echo e(old('villa')); ?>">

    <label class="siac-form-label" for="comuna">Comuna *</label>
    <input type="text" name="comuna" id="comuna" class="siac-form-input" value="Loncoche" readonly>

    <label class="siac-form-label" for="telefono">Teléfono</label>
    <input type="text" name="telefono" id="telefono" class="siac-form-input" value="<?php echo e(old('telefono')); ?>">

    <label class="siac-form-label" for="email">Email *</label>
    <input type="email" name="email" id="email" class="siac-form-input" value="<?php echo e(old('email')); ?>" required>

    <label class="siac-form-label" for="email_confirmation">Confirmación de email *</label>
    <input type="email" name="email_confirmation" id="email_confirmation" class="siac-form-input" value="<?php echo e(old('email_confirmation')); ?>" required>

    <div class="siac-form-actions">
      <a href="<?php echo e(route('solicitudes.reset')); ?>" class="siac-form-btn-restart" onclick="return confirm('¿Está seguro de que desea reiniciar el formulario? Se perderán todos los datos ingresados.')">
        <i class="fas fa-redo"></i> Reiniciar
      </a>
      <button type="submit" class="siac-form-btn">
        <i class="fas fa-arrow-right"></i> Continuar
      </button>
    </div>
  </form>

  <!-- Panel Institucional -->
  <div class="siac-info-panel">
    <img src="/images/logo.png" alt="Logo Municipalidad de Loncoche" class="logo-muni">
    <div class="siac-info-title">Municipalidad de Loncoche</div>
    <div class="siac-info-subtitle">Sistema de Información y Atención Ciudadana</div>
    <div class="siac-info-desc">
      Complete sus datos de contacto para continuar con el proceso de solicitud. Esta información será utilizada para comunicarnos con usted respecto al estado de su solicitud. Es importante que los datos sean correctos y estén actualizados, una vez que la solicitud sea enviada, no podrá modificarlos.
    </div>
    <img src="/images/logo-copihue.png" alt="Loncoche" class="siac-info-img">
  </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="/js/toast-handler.js"></script>
<script>
<?php if($errors->any()): ?>
    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        showToast({
            text: <?php echo json_encode($error, 15, 512) ?>,
            icon: 'error',
            timer: 5000
        });
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('mirror-card'); ?>
<div class="siac-view-contact">
  <?php echo $__env->make('components.mirror_card', ['mirrorStep' => 'contact'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="/css/solicitudes-form.css">
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/siac/resources/views/solicitudes/create_contact.blade.php ENDPATH**/ ?>